/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.common.util;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MaskingUtil {
    private static final String EMAIL_PATTERN = "^[a-z0-9A-Z._-]*@[a-z0-9A-Z]*.[a-zA-Z.]*$";
    private static final String PHONE_PATTERN = "(01[016789])(\\d{3,4})(\\d{4})";
    private static final String IP_ADDRESS_V4_PATTERN = "^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$";
    private static final String IP_ADDRESS_V6_PATTERN = "^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]).){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]).){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))$";
    private static final String IP_ADDRESS_PATTERN = "^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)|(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]).){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]).){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))$";
    private static final int EMAIL_MASKING_MAX = 3;
    private static final int PHONE_MASKING_GROUP = 2;
    private static final int IP_ADDRESS_V4_GROUP = 3;
    private static final int IP_ADDRESS_V6_GROUP = 8;

    public static String getMaskedStr(String str) {
        if (MaskingUtil.isEmail(str)) {
            return MaskingUtil.maskingEamil(str);
        }
        if (MaskingUtil.isPhoneNum(str)) {
            return MaskingUtil.maskingPhoneNum(str);
        }
        if (MaskingUtil.isIpAddress(str)) {
            return MaskingUtil.maskingIpAddress(str);
        }
        return MaskingUtil.maskingName(str);
    }

    public static String getMaskedTarget(String str) {
        if (MaskingUtil.isEmail(str)) {
            return MaskingUtil.maskingEamil(str);
        }
        if (MaskingUtil.isPhoneNum(str)) {
            return MaskingUtil.maskingPhoneNum(str);
        }
        if (MaskingUtil.isIpAddress(str)) {
            return MaskingUtil.maskingIpAddress(str);
        }
        return str;
    }

    public static String getMaskedEmailStr(String str) {
        if (MaskingUtil.isEmail(str)) {
            return MaskingUtil.maskingEamil(str);
        }
        return str;
    }

    public static String getMaskedPhoneNumStr(String str) {
        if (MaskingUtil.isPhoneNum(str)) {
            return MaskingUtil.maskingPhoneNum(str);
        }
        return str;
    }

    public static boolean isEmail(String str) {
        return MaskingUtil.isValid(EMAIL_PATTERN, str);
    }

    public static boolean isPhoneNum(String str) {
        return MaskingUtil.isValid(PHONE_PATTERN, str);
    }

    private static boolean isValid(String regex, String str) {
        Matcher matcher = Pattern.compile(regex).matcher(str);
        return matcher.matches();
    }

    private static String maskingEamil(String str) {
        String regex = "\\b(\\S+)+@(\\S+.\\S+)";
        Matcher matcher = Pattern.compile(regex).matcher(str);
        if (matcher.find()) {
            String notAt = "";
            String asterisk = "";
            String id = matcher.group(1);
            int length = id.length();
            if (length < 3) {
                char[] c = new char[length];
                Arrays.fill(c, '*');
                return str.replace(id, String.valueOf(c));
            }
            if (length == 3) {
                for (int i = 0; i < 2; ++i) {
                    notAt = notAt + "[^@]";
                    asterisk = asterisk + "*";
                }
                return str.replaceAll("\\b(\\S+)" + notAt + "+@(\\S+)", "$1" + asterisk + "@$2");
            }
            for (int i = 0; i < 3; ++i) {
                notAt = notAt + "[^@]";
                asterisk = asterisk + "*";
            }
            return str.replaceAll("\\b(\\S+)" + notAt + "+@(\\S+)", "$1" + asterisk + "@$2");
        }
        return str;
    }

    private static String maskingPhoneNum(String str) {
        String regex = "(01[016789])(\\d{3,4})(\\d{4})$";
        Matcher matcher = Pattern.compile(regex).matcher(str);
        if (matcher.find()) {
            String replaceGroup = matcher.group(2);
            char[] c = new char[replaceGroup.length()];
            Arrays.fill(c, '*');
            return str.replace(replaceGroup, String.valueOf(c));
        }
        return str;
    }

    private static String maskingName(String str) {
        char[] c = new char[str.length() - 2];
        Arrays.fill(c, '*');
        StringBuilder sb = new StringBuilder();
        sb.append(str.charAt(0));
        sb.append("*");
        if (str.length() > 2) {
            sb.append(str.substring(2, str.length()));
        }
        return sb.toString();
    }

    public static boolean isIpAddress(String str) {
        return MaskingUtil.isValid(IP_ADDRESS_PATTERN, str);
    }

    private static String maskingIpAddress(String str) {
        String type;
        String string = MaskingUtil.isValid(IP_ADDRESS_V4_PATTERN, str) ? "4" : (type = MaskingUtil.isValid(IP_ADDRESS_V6_PATTERN, str) ? "6" : null);
        if (type == null) {
            return str;
        }
        String splitPattern = "4".equals(type) ? "." : ":";
        String mask = "4".equals(type) ? "***" : "****";
        int encGroup = "4".equals(type) ? 2 : 7;
        String[] strs = str.split("\\" + splitPattern);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strs.length; ++i) {
            if (i != 0) {
                sb.append(splitPattern);
            }
            if (i == encGroup) {
                sb.append(mask);
                continue;
            }
            sb.append(strs[i]);
        }
        return sb.toString();
    }

    public static String getMaskedIpAddressStr(String str) {
        if (MaskingUtil.isIpAddress(str)) {
            return MaskingUtil.maskingIpAddress(str);
        }
        return str;
    }

    public static String getMaskedNameStr(String str) {
        return MaskingUtil.maskingName(str);
    }

    public static void main(String[] args) {
        String email = "hwang1018kr@humuson.com";
        String phoneNum = "01012345678";
        String name1 = "\uc774\ucca0\uaddc3";
        String name2 = "\ud64d\uae38";
        String name3 = "\ud64d\uae38\uc0bc\ub3d9";
        String ip4 = "202.30.64.22";
        String ip6 = "2001:0230:abcd:ffff:0000:0000:ffff:1111";
        String maskedEmail = MaskingUtil.getMaskedEmailStr(email);
        String maskedPhoneNum = MaskingUtil.getMaskedPhoneNumStr(phoneNum);
        String maskedName1 = MaskingUtil.maskingName(name1);
        String maskedName2 = MaskingUtil.maskingName(name2);
        String maskedName3 = MaskingUtil.maskingName(name3);
        String maskedIp4 = MaskingUtil.maskingIpAddress(ip4);
        String maskedIp6 = MaskingUtil.maskingIpAddress(ip6);
        System.out.println("masked email\t\t: " + maskedEmail);
        System.out.println("masked phone number\t: " + maskedPhoneNum);
        System.out.println("masked name 1\t: " + maskedName1);
        System.out.println("masked name 2\t: " + maskedName2);
        System.out.println("masked name 3\t: " + maskedName3);
        System.out.println("masked ip v4\t: " + maskedIp4);
        System.out.println("masked ip v6\t: " + maskedIp6);
    }
}

