package com.humuson.tms.entityMap.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;

import com.humuson.tms.common.util.StringUtils;

// TODO: Auto-generated Javadoc
/**
 * The Class CustomTimeEditor.
 */
public class CustomTimeEditor extends PropertyEditorSupport {

	/** The date format. */
	private final DateFormat dateFormat;

	/** The allow empty. */
	private final boolean allowEmpty;

	/**
	 * Instantiates a new custom time editor.
	 * 
	 * @param dateFormat the date format
	 * @param allowEmpty the allow empty
	 */
	public CustomTimeEditor(DateFormat dateFormat, boolean allowEmpty) {
		this.dateFormat = dateFormat;
		this.allowEmpty = allowEmpty;
	}

	/**
	 * Parse the Date from the given text, using the specified DateFormat.
	 * 
	 * @param text the new as text
	 * @throws IllegalArgumentException the illegal argument exception
	 */
	@Override
	public void setAsText(String text) throws IllegalArgumentException {
		if (this.allowEmpty && !StringUtils.hasText(text)) {
			// Treat empty String as null value.
			setValue(null);
		} else {
			try {
				setValue(new Time(this.dateFormat.parse(text).getTime()));
			} catch (ParseException ex) {
				throw new IllegalArgumentException("Could not parse date: " + ex.getMessage(), ex);
			}
		}
	}

	/**
	 * Format the Date as String, using the specified DateFormat.
	 * 
	 * @return the as text
	 */
	@Override
	public String getAsText() {
		Time value = (Time) getValue();
		return (value != null ? this.dateFormat.format(value) : "");
	}

}
