package com.humuson.tms.entityMap.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;

import com.humuson.tms.common.util.StringUtils;


/**
 * The Class CustomSqlDateEditor.
 */
public class CustomSqlDateEditor extends PropertyEditorSupport {

	/** The date format. */
	private final DateFormat dateFormat;

	/** The allow empty. */
	private final boolean allowEmpty;

	/** The exact date length. */
	private final int exactDateLength;

	/**
	 * Instantiates a new custom sql date editor.
	 * 
	 * @param dateFormat the date format
	 * @param allowEmpty the allow empty
	 */
	public CustomSqlDateEditor(DateFormat dateFormat, boolean allowEmpty) {
		this.dateFormat = dateFormat;
		this.allowEmpty = allowEmpty;
		this.exactDateLength = -1;
	}

	/**
	 * Instantiates a new custom sql date editor.
	 * 
	 * @param dateFormat the date format
	 * @param allowEmpty the allow empty
	 * @param exactDateLength the exact date length
	 */
	public CustomSqlDateEditor(DateFormat dateFormat, boolean allowEmpty, int exactDateLength) {
		this.dateFormat = dateFormat;
		this.allowEmpty = allowEmpty;
		this.exactDateLength = exactDateLength;
	}

	/**
	 * Parse the Date from the given text, using the specified DateFormat.
	 * 
	 * @param text the new as text
	 * @throws IllegalArgumentException the illegal argument exception
	 */
	@Override
	public void setAsText(String text) throws IllegalArgumentException {
		if (this.allowEmpty && !StringUtils.hasText(text)) {
			// Treat empty String as null value.
			setValue(null);
		} else if (text != null && this.exactDateLength >= 0 && text.length() != this.exactDateLength) {
			throw new IllegalArgumentException("Could not parse date: it is not exactly" + this.exactDateLength
					+ "characters long");
		} else {
			try {
				setValue(new Date(this.dateFormat.parse(text).getTime()));
			} catch (ParseException ex) {
				throw new IllegalArgumentException("Could not parse date: " + ex.getMessage(), ex);
			}
		}
	}

	/**
	 * Format the Date as String, using the specified DateFormat.
	 * 
	 * @return the as text
	 */
	@Override
	public String getAsText() {
		Date value = (Date) getValue();
		return (value != null ? this.dateFormat.format(value) : "");
	}

}
