package com.humuson.tms.constrants;

/**
 * 유저 권한
 *
 * @author 김민찬
 *
 */
public enum TmsUserAuth {
    
    //슈퍼관리자
    Administrator("001", new RoleType[]{RoleType.SEND, RoleType.APPROVAL, RoleType.SITE_MGR, RoleType.ACC_MGR, RoleType.SYS_MGR, RoleType.VIEW_ALL, RoleType.ADMIN},"슈퍼관리자"),

    //일반관리자
    Manager("002", new RoleType[]{RoleType.SEND, RoleType.APPROVAL, RoleType.ACC_MGR, RoleType.VIEW_DEPT},"부서관리자"),

    //일반사용자
    NormalUser("003", new RoleType[]{RoleType.VIEW_USER},"일반사용자"),

    //비인증 사용자 (이메일 인증을 하지 않은 경우)     //이것도 곧 사용하지 않게 될 듯.
    UnAuthorizedUser("-1",new RoleType[]{},"비인증 사용자"),

    //tms service 일반유저                                   //이거 아직 안씀. 사용하게 되면 이 주석을 제거할 것.
    ServiceUser("100", new RoleType[]{RoleType.VIEW_USER},"일반유저"),

    //Custom User. 관리자에 의해 권한이 변경된 유저
    CustomUser("200",new RoleType[]{},"custom user");
    
    final static TmsUserAuth[] MANAGET_LIST = { Administrator , Manager };

    final String code;
    
    final RoleType[] roles;
    
    final String desc; 

    
    TmsUserAuth(String code,RoleType[] roles, String desc) {
        this.code = code;
        this.roles = roles;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }
    
    public RoleType[] getRoles(){
    	return roles;
    }
    
    public String getDesc(){
    	return desc;
    }

    public static boolean isAdministrator(String authId) {
        return Administrator.same(authId);
    }

    
    public static boolean isManager(String authId){
        return Manager.same(authId);
    }
    
    public static boolean checkHaveManagerOrHigherAuth(String authId){
        for(TmsUserAuth userAuth : MANAGET_LIST){
            if(userAuth.same(authId))return true;
        }
        return false;
    }

    public static boolean isNormalUser(String authId) {
        return NormalUser.same(authId);
    }

    public static boolean isUnAuthorizedUser(String authId) {
        return UnAuthorizedUser.same(authId);
    }

    public static boolean isCustomUser(String authId) {
        return CustomUser.same(authId);
    }
    
    protected boolean same(String authId){
        return getCode().equals(authId);
    }
    
    public static TmsUserAuth findUserAuthByCode(String code){
    	for(TmsUserAuth userAuth : values()){
            if(userAuth.same(code)) {
            	return userAuth;
            }
        }
        return null;
    }
}
