package com.humuson.tms.constrants;

public enum TargetStatus {
	RESERVE("T1"),
	CANCEL("T3"),
	CANCEL_COMPLETE("T4"),
    RUNNING("90"),
    ERROR("95"),
    COMPLETE("TC"),
    SPOOL_ERROR("96");

    final String status;

    TargetStatus(String status) {
        this.status = status;
    }

    public String getCode() {
        return status;
    }
    
    public boolean same(String status){
        return getCode().equals(status);
    }
    
    public static String findStatusCode(String code){
        if(code == null)return null;
        String value = null;
        for(TargetStatus status : values()){
            value = status.getCode();
            if(code.indexOf(value) >= 0)return value;
        }
        return null;
    }
    
    /**
     * 넘겨받은 상태값들(targetStatuses)중에 code에 해당되는 targetStatus가 하나라도 있으면 true를 반환한다.
     * @param code
     * @param targetStatuses
     * @return
     */
    public static boolean isIn(String code, TargetStatus ...targetStatuses) {
    	if ( code == null ) {
			return false;
		}
		
		for ( TargetStatus s : targetStatuses ) {
			
			if ( s.same(code) ) {
				return true;
			}
			
		}		
		
		return true;
    }
}
