package com.humuson.tms.constrants;

public enum StatusType {
	PENDDING("00"),
	REJECT_APPROVAL("0R"),
	WAIT_APPROVAL("0A"),
	APPROVAL("05"),
    REGIST("10"),
    RESERVE("20"),
    SENDING("30"),
    STOP_SENDING("31"),
    STOP_SEND_COMPLETE("32"),
    MQ_SENDING("37"),
    CCS_SENDING("38"),
    REGIST_RESEND("35"),
    RESEND("36"),
    COMPLETE("40"),
    ERROR("41"),
    DENY("50"),
    
    FATIGUE_FILTER_RESERVE("60"),
	FATIGUE_FILTER_ON("61"),
	FATIGUE_FILTER_COMPLETE("62"),
    
    REGIST_RESEND_ERROR("45"),
    TARGETING("90"),
    DELETE("99");

    final String status;

    StatusType(String status) {
        this.status = status;
    }

    public String getCode() {
        return status;
    }
    
    public boolean same(String status){
        return getCode().equals(status);
    }
    
    public static String findStatusCode(String code){
        if(code == null)return null;
        String value = null;
        for(StatusType status : values()){
            value = status.getCode();
            if(code.indexOf(value) >= 0)return value;
        }
        return null;
    }
    
    /**
     * 넘겨받은 상태값들(targetStatuses)중에 code에 해당되는 StatusType이 하나라도 있으면 true를 반환한다.
     * @param code
     * @param statusTypes
     * @return
     */
    public static boolean isIn(String code, StatusType ...statusTypes){
    	if ( code == null ) {
			return false;
		}
		
		for ( StatusType s : statusTypes ) {
			
			if ( s.same(code) ) {
				return true;
			}
			
		}		
		
		return true;
    }
}
