package com.humuson.tms.constrants;

/**
 * 
 * @author hyogun
 *
 */
public enum RoleType {

	SEND(RoleType.TYPE_SEND),
	APPROVAL(RoleType.TYPE_APPROVAL),
	SITE_MGR(RoleType.TYPE_SITE_MGR),
	ACC_MGR(RoleType.TYPE_ACC_MGR),
	SYS_MGR(RoleType.TYPE_SYS_MGR),
	VIEW_USER(RoleType.TYPE_VIEW_USER),
	VIEW_DEPT(RoleType.TYPE_VIEW_DEPT),
	VIEW_ALL(RoleType.TYPE_VIEW_ALL),
	ADMIN(RoleType.TYPE_ADMIN),
	CHANNEL_EMAIL(RoleType.TYPE_CHANNEL_EMAIL),
	CHANNEL_PUSH(RoleType.TYPE_CHANNEL_PUSH),
	CHANNEL_SMS(RoleType.TYPE_CHANNEL_SMS),
	CHANNEL_KAKAO(RoleType.TYPE_CHANNEL_KAKAO),
	DOWN_EXCEL(RoleType.TYPE_DOWN_EXCEL),
	ATTACH(RoleType.TYPE_ATTACH);


	public static final String TYPE_SEND				= "ROLE_SEND";
	public static final String TYPE_APPROVAL			= "ROLE_APPROVAL";
	public static final String TYPE_SITE_MGR			= "ROLE_SITE_MGR";
	public static final String TYPE_ACC_MGR				= "ROLE_ACC_MGR";
	public static final String TYPE_SYS_MGR				= "ROLE_SYS_MGR";
	public static final String TYPE_VIEW_USER			= "ROLE_VIEW_USER";
	public static final String TYPE_VIEW_DEPT			= "ROLE_VIEW_DEPT";
	public static final String TYPE_VIEW_ALL			= "ROLE_VIEW_ALL";
	public static final String TYPE_ADMIN				= "ROLE_ADMIN";
	public static final String TYPE_CHANNEL_EMAIL		= "ROLE_CHANNEL_EMAIL";
	public static final String TYPE_CHANNEL_PUSH		= "ROLE_CHANNEL_PUSH";
	public static final String TYPE_CHANNEL_SMS			= "ROLE_CHANNEL_SMS";
	public static final String TYPE_CHANNEL_KAKAO		= "ROLE_CHANNEL_KAKAO";
	public static final String TYPE_DOWN_EXCEL			= "ROLE_DOWN_EXCEL";
	public static final String TYPE_ATTACH				= "ROLE_ATTACH";

	
	final String role;
	
	//public static final String PREFIX = "ROLE_";


	
	RoleType(String role) {
        this.role = role;
    }

    public String getRole() {
        return role;
    }
    
    /*public String getCode(){
    	return role.substring(PREFIX.length(), role.length());
    }*/
    
    public boolean same(String status){
        return getRole().equals(status);
    }
    
	public static RoleType find(String role) {
        if(role == null)return null;
        for(RoleType status : values()){
        	if ( status.getRole().equals(role) ) {
        		return status;
        	}
        }
        return null;
    }
    
}
