package com.humuson.tms.constrants;



/**
 * 연관 타게팅 condition type
 */

public enum RelTargetCondType {

    
	TARGET("TARGET"),
	SUCCESS("SUCCESS"),
	FAIL("FAIL"),
	OPEN("OPEN"),
	CLICK("CLICK");
	
    final String code;

    RelTargetCondType(String code) {
        this.code = code;
    }

    public String getCode() {
        return code;
    }
    
    public boolean same(String code) {
        return getCode().equals(code);
    }
    
    public static RelTargetCondType valueOfCode(String code) throws IllegalArgumentException {
		for (RelTargetCondType eCode : RelTargetCondType.values()) {
			if (eCode.getCode().equals(code)) {
				return eCode;
			}
		}

        throw new IllegalArgumentException("No enum constant " + code);
    }
   
}
