package com.humuson.tms.constrants;

/**
 * Optimize 대상자 추출 타입
 */

public enum OptmzTargetType {

    ALL("A"),
    SUCCESS("S"),
    FAIL("F"),
    OPEN("O"),
    NOT_OPEN("NO"),
    CLICK("C"),
    NOT_CLICK("NC");

    final String code;

    OptmzTargetType(String code) {
        this.code = code;
    }

    public String getCode() {
        return code;
    }
    
    public boolean same(String channelTypeCode){
        return getCode().equals(channelTypeCode);
    }
    
    public static String findChannelTypeCode(String str){
        if(str == null) return null;
        String typeValue = null;
        for(OptmzTargetType channelType : values()){
            typeValue = channelType.getCode();
            if(str.indexOf(typeValue) >= 0) return typeValue;
        }
        return null;
    }
}
