package com.humuson.tms.constrants;

/**
 * TMS_CODE_INFO 테이블 내 리스트를 가져올때 사용할 CODE_CODE 값을 선언.
 */
public enum CodeType {
	// 발송서버 리스트 CODE_TYPE
	SERVER_LIST("04"),
	// 파일 타겟팅시 구분자 리스트 CODE_TYPE
	DELIMITER("60"),
	// 자동메일 발송 주기
	AUTO_CYCLE("84"),
	// 자동메일 발송 주기 요일
	AUTO_CYCLE_WEEK("85"),
	// 자동메일 언어셋 타입
	LANG("U1"),
	// 자동메일 쿼리 타입
	QUERY_TYPE("98"),
	// PUSH 앱 리스트
	APP_TYPE("AP");
	
	final String code;

	CodeType(String code) {
        this.code = code;
    }

    public String getCode() {
        return code;
    }
    
    public boolean same(String status){
        return getCode().equals(status);
    }
    
    public static String findStatusCode(String code){
        if(code == null)return null;
        String value = null;
        for(CodeType status : values()){
            value = status.getCode();
            if(code.indexOf(value) >= 0)return value;
        }
        return null;
    }
}
