package com.humuson.tms.constrants;

import com.humuson.tms.common.util.StringUtils;


public enum AutoPlanQueryInfo {
    MYSQL_TARGET_LIST(AutoPlanQueryType.TARGET_LIST,"SELECT SRC_WORKDAY, SRC_SEQNO, SRC_MEMBER_ID AS EMS_M_ID, SRC_MEMBER_ID_SEQ, SRC_LIST_TABLE "
            + "FROM PLAN_ACT_LIST "
            + "WHERE MSG_TYPE = @{MSG_TYPE} AND MSG_TYPE_SEQ = @{MSG_TYPE_SEQ} "
            + "AND ACT_DATE < NOW() AND SEND_FLAG_DATE IS NULL"),
            
    MYSQL_LIST_MAPPING(AutoPlanQueryType.LIST_MAPPING,"SELECT MSG_NAME AS EMS_M_NAME, "
            + "  ETC1    AS EMS_M_MSGTO  "
            + " FROM TMS_TEST_PLAN_SAMPLE A  "
            + " WHERE SEQ = '@{EMS_M_ID}' "),
    
    MYSQL_UPDATE(AutoPlanQueryType.UPDATE,"UPDATE PLAN_ACT_LIST "
            + " SET SEND_FLAG_DATE = NOW() WHERE MSG_TYPE = @{MSG_TYPE}  "
            + "AND MSG_TYPE_SEQ = @{MSG_TYPE_SEQ}  AND SRC_WORKDAY = '@{SRC_WORKDAY}'  "
            + "AND SRC_SEQNO = '@{SRC_SEQNO}'  AND SRC_MEMBER_ID = '@{EMS_M_ID}'  "
            + "AND SRC_MEMBER_ID_SEQ = '@{SRC_MEMBER_ID_SEQ}'");
    
    final AutoPlanQueryType autoPlanQueryType;
    
    final String defaultQuery;
    
    AutoPlanQueryInfo(AutoPlanQueryType autoPlanQueryType, String defaultQuery) {
        this.autoPlanQueryType = autoPlanQueryType;
        this.defaultQuery = defaultQuery;
    }
    
    public String getDefaultQuery(String msgType, String msgTypeSeq){
        String query = defaultQuery;
        if(StringUtils.isNotEmpty(msgType)){
            query = query.replaceAll("[@]\\{MSG_TYPE\\}", "'"+msgType+"'");
        }
        
        if(StringUtils.isNotEmpty(msgTypeSeq)){
            query = query.replaceAll("[@]\\{MSG_TYPE_SEQ\\}", "'"+msgTypeSeq+"'");
        }
        
        return query;
    }

    public String getQueryType() {
        return autoPlanQueryType.getCode();
    }
    
}
