/*
 * @(#)XmlUtil.java            2004. 10. 29.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package com.humuson.tms.common.xml;

import java.util.LinkedList;

import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/**
 * Utilities about xml 
 * 
 * @version		1.1
 * @author 		dragon
 *
 */
public class XmlUtil extends java.lang.Object {
	
	/**
	 * Creates new XmlUtil
	 */
	public XmlUtil() {
	}
	
	public static final Element append( 
			Document doc, Element root, 
			String node_name, String node_value ) 
		throws Exception {
			
		Element add = doc.createElement( node_name );
		add.setAttribute( "value" , node_value );
		return (Element)root.appendChild( add );
	}
	
	public static final Element uniqueAppend( 
			Document doc, Element root, 
			String node_name, String node_value ) 
		throws Exception {
			
		NodeList sub_list = root.getChildNodes();
		
		Node tmp_node = null;
		
		for( int idx = 0 ; idx < sub_list.getLength() ; idx++ ) {
			tmp_node = sub_list.item(idx);
			
			if( tmp_node.getNodeType() != Node.ELEMENT_NODE ) continue;
			
			if( tmp_node.getNodeName().equals( node_name ) 
					&& ( (Element)tmp_node).getAttribute("value").equals( node_value ) ) {

				return (Element)tmp_node;
			}
		}
		
		return append( doc , root , node_name , node_value );
	}
	
	public static final String getCDATA_SECTION( Node __TARGET_NODE__ ) {
		
		return getCDATA_SECTION( __TARGET_NODE__ , null );
	}
	
	public static final String getCDATA_SECTION( 
			Node __TARGET_NODE__ , String defaultValue ) {
				
		NodeList __SUB_NODES__ = __TARGET_NODE__.getChildNodes();
		
		Node __SUB_NODE__ = null;
		
		for( int j = 0 ; j < __SUB_NODES__.getLength() ; j++ ) {
			__SUB_NODE__ = __SUB_NODES__.item(j);
			
			if( __SUB_NODE__.getNodeType() == Node.CDATA_SECTION_NODE ) {
				return ((CharacterData)__SUB_NODE__).getData();
			}
		}
		
		return defaultValue;
	}
	
	public static final String getCDATA_SECTION_OR_TEXT_NODE( 
			Node __TARGET_NODE__ ) {
				
		NodeList __SUB_NODES__ = __TARGET_NODE__.getChildNodes();
		
		Node __SUB_NODE__ = null;
		
		for( int j = 0 ; j < __SUB_NODES__.getLength() ; j++ ) {
			__SUB_NODE__ = __SUB_NODES__.item(j);
			
			if( __SUB_NODE__.getNodeType() == Node.CDATA_SECTION_NODE ) {
				return ((CharacterData)__SUB_NODE__).getData();
			}
			
			if( __SUB_NODE__.getNodeType() == Node.TEXT_NODE ) {
				String tmpValue = ((Text)__SUB_NODE__).getData().trim();
				if( tmpValue.length() > 0 ) return tmpValue;
			}
		}
		
		return null;
	}
	
	@SuppressWarnings("rawtypes")
	public static final LinkedList getMultiCDATA_SECTION( 
			Node __TARGET_NODE__ ) {
				
		NodeList __SUB_NODES__ = __TARGET_NODE__.getChildNodes();
		
		Node __SUB_NODE__ = null;
		
		LinkedList<String> returnValue = new LinkedList<String>();
		
		for( int j = 0 ; j < __SUB_NODES__.getLength() ; j++ ) {
			__SUB_NODE__ = __SUB_NODES__.item(j);
			
			if( __SUB_NODE__.getNodeType() == Node.CDATA_SECTION_NODE ) {
				returnValue.addLast(((CharacterData)__SUB_NODE__).getData());
			}
		}
		
		return returnValue;
	}
	
	public static final LinkedList<String> getMultiCDATA_SECTION_OR_TEXT_NODE( 
			Node __TARGET_NODE__ ) {
				
		NodeList __SUB_NODES__ = __TARGET_NODE__.getChildNodes();
		
		Node __SUB_NODE__ = null;
		
		LinkedList<String> returnValue = new LinkedList<String>();
		
		for( int j = 0 ; j < __SUB_NODES__.getLength() ; j++ ) {
			__SUB_NODE__ = __SUB_NODES__.item(j);
			
			if( __SUB_NODE__.getNodeType() == Node.CDATA_SECTION_NODE ) {
				returnValue.addLast(((CharacterData)__SUB_NODE__).getData());
			}
			if( __SUB_NODE__.getNodeType() == Node.TEXT_NODE ) {
				String tmpValue = ((Text)__SUB_NODE__).getData().trim();
				if( tmpValue.length() > 0 ) 
					returnValue.addLast(((CharacterData)__SUB_NODE__).getData());
			}
		}
		
		return returnValue;
	}
	
	public static final String getSubElementAttribute( 
			Element __ROOT_ELEMENT__ , String elm_name , String att_name ) {
		NodeList sublist = __ROOT_ELEMENT__.getElementsByTagName( elm_name );
		
		if( sublist == null ) return null;
		
		return ( ( Element )sublist.item( 0 ) ).getAttribute( att_name );
	}
	
	public static final Element getFirstNamedElement( 
			Element __ROOT_ELEMENT__ , String elm_name ) {
		NodeList sublist = __ROOT_ELEMENT__.getElementsByTagName( elm_name );
		
		if( sublist == null ) return null;
		
		return ( Element )sublist.item( 0 );
	}
}

