package com.humuson.tms.common.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * Created with IntelliJ IDEA.
 * User: 민찬
 * Date: 14. 4. 8
 * Time: 오후 2:14
 * To change this template use File | Settings | File Templates.
 */
@Slf4j
public class ShowObject {

    public static void show(Object obj){
        show(obj,false);
    }

    @SuppressWarnings("rawtypes")
	public static void show(Object obj,boolean showType){
        if(obj instanceof Map){
            showMap((Map)obj,0,showType);
        }else if(obj instanceof List){
            showList((List)obj,0,showType);
        }else{
            if(showType){
                log.debug("("+getType(obj)+")"+obj);
            }else{
            	log.debug("{}", obj);
            }

        }
    }

    @SuppressWarnings("rawtypes")
	private static void showMap(Map map,int dept,boolean showType){
        for(Object key : map.keySet()){
            Object val = map.get(key);
            if(val instanceof Map){
                showMap((Map)val,dept+1,showType);
            }else if(val instanceof List){
                showList((List)val,dept+1,showType);
            }else{
                log.debug(getObjStr(val, key, showType));
            }
        }
    }

    @SuppressWarnings("rawtypes")
	private static void showList(List list,int dept,boolean showType){
        for(Object obj : list){
            if(obj instanceof Map){
                showMap((Map)obj,dept+1,showType);
            }else if(obj instanceof List){
                showList((List)obj,dept+1,showType);
            }else{
                log.debug(getObjStr(obj, null, showType));
            }
        }
    }


    public static <T> void showBean(String header,T bean) {
    	log.debug(header);
        showBean(bean);
    }

    public static void show2(String header,Object obj){
    	log.debug(header);
        show2(obj);
    }

    public static <T> void showBean(T bean) {
        Class<? extends Object> cls = bean.getClass();
        Method[] methods = cls.getDeclaredMethods();
        for(int i=0; i<methods.length;i++){
            if(methods[i].getName().indexOf("get") == 0){
                try {
                	log.debug(methods[i].getName()+" : "+methods[i].invoke(bean));
                } catch (IllegalArgumentException e) {
                	log.error("IllegalArgumentException", e);
                } catch (IllegalAccessException e) {
                	log.error("IllegalAccessException", e);
                } catch (InvocationTargetException e) {
                	log.error("InvocationTargetException", e);
                }
            }
        }
    }

    public static void show2(Object obj){
        ToStringStyle style = ToStringStyle.MULTI_LINE_STYLE;
        ReflectionToStringBuilder tsb = new ReflectionToStringBuilder(obj, style);
        log.debug(tsb.toString());
    }

    private static String getType(Object obj){
        return obj.getClass().getSimpleName();
    }

    private static int getCode(Object[] array){
        StringBuffer codeBuffer = new StringBuffer();
        for(int i=0,j=array.length;i<j;i++){
            if(array[i] != null)codeBuffer.append("1");
            else codeBuffer.append("0");
        }
        return Integer.parseInt(codeBuffer.toString());
    }

    private static String makeObjShowStr(Object... obj){
        switch (getCode(obj)){
            case 100:
                return String.format(" %10s ",obj[0]);
            case 101:
                return String.format(" (%5s)%10s ",obj[2],obj[0]);
            case 110:
                return String.format(" [%5s : %10s] ",obj[1],obj[0]);
            case 111:
                return String.format(" [%5s : (%5s)%10s] ",obj[1],obj[2],obj[0]);
        }
        return null;
    }

    private static String getObjStr(Object value,Object key, boolean showType){
        return makeObjShowStr(value,key,(showType)?getType(value):null );
    }

}
