package com.humuson.tms.common.util;

import java.util.Locale;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.MessageSourceAccessor;

/**
 * The Class MessageUtil.
 */
public class MessageUtil {

	/** The ms acc. */
	private static MessageSourceAccessor msAcc;
	
	private static Locale locale= LocaleContextHolder.getLocale();
		
	/**
	 * Sets the message source accessor.
	 *
	 * @param msAcc the new message source accessor
	 */
	public void setMessageSourceAccessor(MessageSourceAccessor msAcc){
		MessageUtil.msAcc = msAcc;
	}
	
	/**
	 * 키에 해당하는 메세지 반환
	 *
	 * @param key the key
	 * @return the message
	 */
	public static String getMessage(String key){
		return msAcc.getMessage(key, Locale.getDefault());
	}
	
	public void setLocale(Locale locale){
		this.locale = locale;
	}
	
	/**
	 * 키에 해당하는 메세지 반환 (파라미터 포함)
	 *
	 * @param key the key
	 * @param objs the objs
	 * @return the message
	 */
	public static String getMessage(String key, Object[] objs){
		return msAcc.getMessage(key, objs, Locale.getDefault());
	}

	public static String get(String key, Locale locale){
		return msAcc.getMessage(key, locale);
	}

	public static String get(String key){
		return msAcc.getMessage(key, LocaleContextHolder.getLocale());
	}
	public static String get(String key, Object[] objectArray){
		return msAcc.getMessage(key, objectArray, LocaleContextHolder.getLocale());
	}

	public static String get(String key, String oneMappingData ){
		return msAcc.getMessage(key, new String[]{oneMappingData}, LocaleContextHolder.getLocale());
	}

	public static String get(String key, Object[] objectArray, Locale locale){
		return msAcc.getMessage(key, objectArray, locale);
	}
}
