package com.humuson.tms.common.util;

import org.apache.commons.io.FilenameUtils;


/**
 * 파일 확장자 검사 유틸
 * isExtension Method에서 String.equals 로 비교하기 때문에 LowerCase로 변경 후 검증.
 * @author 황집중
 *
 */
public class FileExtentionUtil {

	public static final String[] RESTRICTED_EXTENTIONS 		= { "jsp", "asp", "cgi", "php", "php3", "inc", "pl" };
	public static final String[] IMAGE_FILE_EXTENTIONS		= { "gif", "png", "jpg", "jpeg" };
	public static final String[] TARGETING_FILE_EXTENTIONS	= { "txt", "csv", "xls", "xlsx" };
	public static final String[] P12_FILE_EXTENTIONS		= { "p12" };
	
	
	/**
	 * 제한된 확장자 파일 체크
	 * @param fileName
	 * @return boolean
	 */
	public static boolean isValidExtention(String fileName) {
		
		fileName = fileName.toLowerCase();
		
		return !FilenameUtils.isExtension(fileName, RESTRICTED_EXTENTIONS);
		
	}
	
	/**
	 * 이미지 파일 확장자 체크
	 * @param fileName
	 * @return boolean
	 */
	public static boolean isImageFileExtention(String fileName) {
		
		fileName = fileName.toLowerCase();
		
		if(isValidExtention(fileName)) {
			return FilenameUtils.isExtension(fileName, IMAGE_FILE_EXTENTIONS);
		} else {
			return false;
		}
		
	}
	
	/**
	 * 타게팅 파일 확장자 체크
	 * @param fileName
	 * @return boolean
	 */
	public static boolean isTargetingFileExtention(String fileName) {
		
		fileName = fileName.toLowerCase();
		
		if(isValidExtention(fileName)) {
			return FilenameUtils.isExtension(fileName, TARGETING_FILE_EXTENTIONS);
		} else {
			return false;
		}
		
	}
	
	/**
	 * P12 인증서 파일 확장자 체크
	 * @param fileName
	 * @return boolean
	 */
	public static boolean isP12FileExtention(String fileName) {
		
		fileName = fileName.toLowerCase();
		
		if(isValidExtention(fileName)) {
			return FilenameUtils.isExtension(fileName, P12_FILE_EXTENTIONS);
		} else {
			return false;
		}
		
	}
	
}
