package com.humuson.tms.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.DefaultPropertiesPersister;
import org.springframework.util.StringUtils;

import com.humuson.tms.common.security.HumusonDecryptor;

public class DecryptPropertiesPersister extends DefaultPropertiesPersister {

	private Logger logger = LoggerFactory.getLogger(DecryptPropertiesPersister.class);
	
	private static final String PREFIX_ENCRYPT = "enc.";
	private static final String SURFIX_PASSWORD = ".password";
	
	private String encryptKey;
	
	@Override
	public void load(Properties props, Reader reader) throws IOException {
		doLoad(props, reader);
	}
	
	@Override
	protected void doLoad(Properties props, Reader reader) throws IOException {
		// TODO Auto-generated method stub
		BufferedReader in = new BufferedReader(reader);
		while (true) {
			String line = in.readLine();
			if (line == null) {
				return;
			}
			line = StringUtils.trimLeadingWhitespace(line);
			if (line.length() > 0) {
				char firstChar = line.charAt(0);
				if (firstChar != '#' && firstChar != '!') {
					while (endsWithContinuationMarker(line)) {
						String nextLine = in.readLine();
						line = line.substring(0, line.length() - 1);
						if (nextLine != null) {
							line += StringUtils.trimLeadingWhitespace(nextLine);
						}
					}
					int separatorIndex = line.indexOf("=");
					if (separatorIndex == -1) {
						separatorIndex = line.indexOf(":");
					}
					String key = (separatorIndex != -1 ? line.substring(0, separatorIndex) : line);
					String value = (separatorIndex != -1) ? line.substring(separatorIndex + 1) : "";
					
					key = StringUtils.trimTrailingWhitespace(key);
					value = StringUtils.trimLeadingWhitespace(value);
					
					try {
						if (key.startsWith(PREFIX_ENCRYPT)
								&& key.endsWith(SURFIX_PASSWORD)) {
							logger.info("before key :{}, value:{}", key, value);
							if (encryptKey != null && !"".equals(encryptKey)) {
								value = HumusonDecryptor.decrypt(value, encryptKey);
							} else {
								value = HumusonDecryptor.decrypt(value);
							}
							logger.info("after key :{}, value:{}", key, value);
						}
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
						logger.error("decrypr fail", e);
					}
					
					props.put(unescape(key), unescape(value));
				}
			}
		}
	}
	
	public void setEncryptKey(String encryptKey) {
		this.encryptKey = encryptKey;
	}
}
