package com.humuson.tms.common.security;

import org.apache.xmlbeans.impl.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.humuson.tms.common.zip.HumusonZip;
/**
 * humuson 에서 사용하는 복호화 클래스
 * seed 128 bit로 암호화된 정보를 복호화하는 역활을 수행 함
 * @author hyogun
 *
 */
public class HumusonDecryptor {
	private static final Logger logger = LoggerFactory.getLogger(HumusonDecryptor.class);

	public static String FREEKEY = "Pg-s_E_n_C_k_e_y";

	public static String generateKey(String key) {

		String genKey = null;

		if( key == null ) {
			genKey = FREEKEY.substring(0,16);
		} else {

			if( key.length() > 16 ) {
				genKey = key.substring(0,16);
			} else {
				genKey = key + ( FREEKEY.substring(0,16-key.length())  );
			}
		}
		return genKey;
	}

	public static String generateKey(String key, String freeKey) {

		String genKey = null;

		if( key == null ) {
			genKey = freeKey.substring(0,16);
		} else {

			if( key.length() > 16 ) {
				genKey = key.substring(0,16);
			} else {
				genKey = key + ( freeKey.substring(0,16-key.length())  );
			}
		}
		return genKey;
	}

	public static String decrypt(String str) throws Exception {
		return decrypt(str, FREEKEY);
	}

	public static String decrypt(String str, String userKey) throws Exception{
		return decrypt(str, userKey, true);
	}

	public static String decrypt(String str, String userKey, boolean useZip) throws Exception{
		if( str == null ) return null;
		String returnStr = "";
		try {
			if (userKey.length() < 16) userKey = generateKey(userKey);
			else userKey = userKey.substring(0, 16);

			byte[] dec2 = userKey==null ?
					Seed.seedDecrypt(Base64.decode(str.getBytes()))
					:Seed.seedDecrypt(Base64.decode(str.getBytes()), userKey.getBytes());

			if (useZip) {
				returnStr = HumusonZip.unzipStringFromBytes(dec2);
			} else {

				int i;
				for (i = 0; i < dec2.length && dec2[i] != 0; i++) { }

				returnStr = new String(dec2, 0, i);
			}

		} catch (Exception e) {
			logger.error("decrypt error :{} param[str:{}, userKey:{}, useZip:{}]", returnStr, str, userKey, useZip);
			throw e;
		} finally {
			if (logger.isDebugEnabled())
				logger.debug("decrypt:{} param[str:{}, userKey:{}, useZip:{}]", returnStr, str, userKey, useZip);
		}
		return returnStr;
	}

	public static void main(String[] args) {
		String str = "6LVmciteIAer1PGJ34DpIA==";
		
	
		try {
			str = HumusonDecryptor.decrypt(str, "amail0722!@", false);
			System.out.println(str+"///");
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}
}
