package com.humuson.tms.common.model.target;

import lombok.Data;
import lombok.experimental.Accessors;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * Targeting schedule 정보
 * @author hyogun
 *
 */
@Data
@Accessors(chain=true)
public class TargetInfo {
	public static final String SITE_ID = "SITE_ID";
	public static final String TARGET_CNT = "TARGET_CNT";
	public static final String FIRST_CHANNEL_TYPE = "FIRST_CHANNEL_TYPE";
	public static final String TARGET_TYPE = "TARGET_TYPE";
	public static final String TARGET_DB_QUERY = "TARGET_DB_QUERY";
	
	public static final String WHERE_INFO = "WHERE_INFO";
	public static final String NEXT_TARGET_YN = "NEXT_TARGET_YN";
	public static final String AB_TEST_YN = "AB_TEST_YN";
	public static final String ID_TARGET_YN = "ID_TARGET_YN";
	public static final String USE_LOGIN = "USE_LOGIN";
	public static final String USE_PLATFORM = "USE_PLATFORM";
	public static final String USE_CONDITION = "USE_CONDITION";
	public static final String ADD_SITE_USER_YN = "ADD_SITE_USER_YN";
	public static final String ENCRYPT_YN = "ENCRYPT_YN"; 
	public static final String MKT_YN = "MKT_YN";
	public static final String DEDUPLICATION_YN = "DEDUPLICATION_YN";
	public static final String SEQNO = "SEQNO";
	
	public static final String AUDIENCE_SEQ = "AUDIENCE_SEQ";
	
	public static final String APP_GRP_ID = "APP_GRP_ID";
	
	private int siteId;
	private String mktYn;
	private String firstChannelType;
	private String postId;
	private String gPostId;
	private String targetType;
	private String TargetStatus;
	private String useLogin;
	private String usePlatform;
	private String useCondition;
	private String deduplicationYn;
	private String seqNo;
	
	private String targetQuery;
	
	// 대상 타겟 건수
	private int targetTotalCnt = 0;
	// 실 타겟 건수
	private int targetCnt = 0;
	
	private int filterDomainCnt = 0;
	private int filterInvalidCnt = 0;
	private int filterErrorCnt = 0;
	
	private String startTime;
	private String endTime;
	
	private String targetDetail;
	
	private String registerId;
	
	private String whereInfo;
//	private String domainFilterFlag = "N";
	private String nextTarget = "N";
	private String abTestFileYn = "N";
	private String idTargetYn = "N";
	private String addSiteUserYn = "N";
	private String encryptYn = "N";
	
	private int filterDelCnt = 0;
	private TargetCondInfo targetCondInfo;
	private TargetFileInfo targetFileInfo;
	private TargetDbInfo targetDbInfo;
	
	private int appGrpId = 0;
	
	//AMC Audience Unique No
	private int audienceSeq;
	
	@Override
    public String toString() {
        ToStringStyle style = ToStringStyle.MULTI_LINE_STYLE;
        ReflectionToStringBuilder tsb = new ReflectionToStringBuilder(this, style);
        return tsb.toString();
    }
}
