package com.humuson.tms.common.model.target;

import lombok.Data;
import lombok.experimental.Accessors;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Data
@Accessors(chain=true)
public class TargetDbInfo {
	
	public static final String DB_TYPE = "DB_TYPE";
	public static final String DB_DRV = "DB_DRV";
	public static final String DB_URL = "DB_URL";
	public static final String DB_USR = "DB_USR";
	public static final String DB_PWD = "DB_PWD";
	
	private String dbType;
	private String dbId;
	private String dbDriver;
	private String dbUrl;
	private String dbUser;
	private String dbPassword;
	
	@Override
    public String toString() {
        ToStringStyle style = ToStringStyle.MULTI_LINE_STYLE;
        ReflectionToStringBuilder tsb = new ReflectionToStringBuilder(this, style);
        return tsb.toString();
    }
}
