package com.humuson.tms.common.model.mq;

import java.io.Serializable;

public class BaseMessage implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = -2945697163272725416L;

	public enum MessageType {
		MULTICAST(0x00), ONE2ONE(0x01);
		
		private int code;

		private MessageType(int code) {
			this.code = code;
		}

		public int getCode() {
			return code;
		}
		
		public static MessageType valueOfCode(int code) throws IllegalArgumentException {
			for (MessageType eCode : MessageType.values()) {
				if (eCode.getCode() == code) {
					return eCode;
				}
			}

	        throw new IllegalArgumentException("No enum constant " + code);
	    }
	}
	
	public enum Type {
		APNS(0x00), GCM(0x01), PRIVATE(0x02), REPORT(0x03), UNKOWN(0x10);

		private int code;

		private Type(int code) {
			this.code = code;
		}

		public int getCode() {
			return code;
		}
		
		public static Type valueOfCode(int code) throws IllegalArgumentException {
			for (Type eCode : Type.values()) {
				if (eCode.getCode() == code) {
					return eCode;
				}
			}

	        throw new IllegalArgumentException("No enum constant " + code);
	    }
	}
}
