package com.humuson.beans.factory.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.Resource;
import org.springframework.util.PropertiesPersister;

public class DecryptPropertyPlaceholderConfigurer extends PropertyPlaceholderConfigurer {

	Logger logger = LoggerFactory.getLogger(DecryptPropertyPlaceholderConfigurer.class);
	
	private Resource[] locations;  
    
    private PropertiesPersister propertiesPersister;  
       
    private String fileEncoding = "utf-8";  
       
    private boolean ignoreResourceNotFound = false;  
       
    /** 
     * {@inheritDoc} 
     */  
    @Override  
    public void setLocations(Resource[] locations) {  
        this.locations = locations;  
    }  
       
    /** 
     * {@inheritDoc} 
     */  
    @Override  
    public void setFileEncoding(String encoding) {  
        this.fileEncoding = encoding;  
    }  
       
    /** 
     * {@inheritDoc} 
     */  
    @Override  
    public void setIgnoreResourceNotFound(boolean ignoreResourceNotFound) {  
        this.ignoreResourceNotFound = ignoreResourceNotFound;  
    }  
       
    /** 
     * {@inheritDoc} 
     */  
    @Override  
    public void loadProperties(Properties props) throws IOException {  
        if (this.locations != null) {  
            //   
            for(int i = 0; i < this.locations.length; i++) {  
                Resource location = this.locations[i];  
                   
                InputStream is = null;  
                try {  
                    is = location.getInputStream();  
                       
                    this.propertiesPersister.load(props, new InputStreamReader(is, this.fileEncoding));  
                } catch (IOException ex) {  
                    if (this.ignoreResourceNotFound) {  
                        if (logger.isWarnEnabled()) {  
                            logger.warn("Could not load properties from " + location + ": " + ex.getMessage());  
                        }  
                    } else {  
                        throw ex;  
                    }  
                }  
                finally {  
                    if (is != null) {  
                        is.close();  
                    }  
                }  
            }  
        }  
    }

    public void setPropertiesPersister(PropertiesPersister propertiesPersister) {
    	this.propertiesPersister = propertiesPersister;
    }
}
