/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.common.util;

import com.humuson.tms.common.security.HumusonEncryptor;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateConverter {
    private static final Logger logger = LoggerFactory.getLogger(HumusonEncryptor.class);
    public static final String DEFAULT_DATE_FORMAT = "yyyyMMdd";
    public static final Locale DEFAULT_LOCALE = Locale.KOREA;

    public static String getCurrentDate(String format) {
        if (format == null || format.length() == 0) {
            format = DEFAULT_DATE_FORMAT;
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        Date date = new Date();
        return DateConverter.getFormattedDate(date, df);
    }

    public static String getCurrentDate(String format, String timezone) {
        if (format == null || format.length() == 0) {
            format = DEFAULT_DATE_FORMAT;
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setTimeZone(TimeZone.getTimeZone(timezone));
        Date date = new Date();
        return DateConverter.getFormattedDate(date, df);
    }

    public static String getFormattedDate(String date, String format) {
        if (format == null || format.length() == 0) {
            format = DEFAULT_DATE_FORMAT;
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static String getFormattedDate(String date, String format, String format2) {
        if (date == null || date.length() == 0) {
            return null;
        }
        if (format == null || format.length() == 0) {
            format = DEFAULT_DATE_FORMAT;
        }
        try {
            return DateConverter.getFormattedDate(DateConverter.convertString2Date(date, format), format2);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getFormattedDate(String date, String format, String format2, String timezone) {
        if (date == null || date.length() == 0) {
            return null;
        }
        if (format == null || format.length() == 0) {
            format = DEFAULT_DATE_FORMAT;
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            Date d = df.parse(date);
            return DateConverter.getFormattedDate(d, format2, timezone);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date convertString2Date(String date, String format) throws ParseException {
        if (date == null || date.length() == 0) {
            return null;
        }
        if (format == null || format.length() == 0) {
            format = DEFAULT_DATE_FORMAT;
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.parse(date);
    }

    public static String getFormattedDate(Date date, String format) {
        if (format == null || format.length() == 0) {
            format = DEFAULT_DATE_FORMAT;
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static String getFormattedDate(Date date, String format, String timezone) {
        if (format == null || format.length() == 0) {
            format = DEFAULT_DATE_FORMAT;
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        if (timezone != null && !timezone.equals("")) {
            timezone = "GMT" + timezone;
        }
        df.setTimeZone(TimeZone.getTimeZone(timezone));
        return df.format(date);
    }

    public static String getFormattedDate(Date date, DateFormat df) {
        if (logger.isDebugEnabled()) {
            logger.debug("getFormattedDate : {}", (Object)df.format(date));
        }
        return df.format(date);
    }

    public static String changeCurrentDay(int days, String format) {
        SimpleDateFormat df = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        try {
            Date date = df.parse(format);
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            c.add(5, days);
            Date d = c.getTime();
            return DateConverter.getFormattedDate(d, df);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String addCurrentDays(int days) {
        return DateConverter.addDays(new Date(), days, DEFAULT_DATE_FORMAT);
    }

    public static String addCurrentDays(int days, String format) {
        if (format == null || format.length() == 0) {
            format = DEFAULT_DATE_FORMAT;
        }
        return DateConverter.addDays(new Date(), days, format);
    }

    public static String addDays(Date date, int days, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return DateConverter.addDays(date, days, df);
    }

    public static String addDays(Date date, int days, DateFormat df) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, days);
        Date d = c.getTime();
        return DateConverter.getFormattedDate(d, df);
    }

    public static String addCurrentMonth(int month, String format) {
        if (format == null || format.length() == 0) {
            format = DEFAULT_DATE_FORMAT;
        }
        return DateConverter.addMonth(new Date(), month, format);
    }

    public static String addMonth(String date, String format, int month, String target) {
        Date d;
        SimpleDateFormat df = new SimpleDateFormat(target);
        try {
            d = DateConverter.convertString2Date(date, format);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        return DateConverter.addMonth(d, month, df);
    }

    public static String addMonth(Date date, int month, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return DateConverter.addMonth(date, month, df);
    }

    public static String addMonth(Date date, int month, DateFormat df) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, month);
        return DateConverter.getFormattedDate(c.getTime(), df);
    }

    public static String calcDaysFromAddMonth(String fromDate, String dateFormat, int month) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        TimeZone tz = TimeZone.getTimeZone("UTC");
        sdf.setTimeZone(tz);
        String presentStr = sdf.format(new Date().getTime());
        SimpleDateFormat df = new SimpleDateFormat(dateFormat);
        try {
            Date pDate = df.parse(presentStr);
            Date fDate = df.parse(fromDate);
            String toDate = DateConverter.addMonth(fDate, month, df);
            Date tDate = df.parse(toDate);
            long diff = tDate.getTime() - pDate.getTime();
            if (logger.isDebugEnabled()) {
                logger.debug("calc days diff : {}", (Object)diff);
            }
            boolean isMinus = false;
            if (diff < 0L) {
                isMinus = true;
            }
            long diffDays = diff / 86400000L;
            if (isMinus) {
                return "-" + Long.toString(diffDays);
            }
            return Long.toString(diffDays);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String calcDaysFromDate(String fromDate, String toDate, String dateFormat) {
        try {
            if (fromDate.length() > 0 && toDate.length() > 0 && dateFormat.length() > 0) {
                SimpleDateFormat df = new SimpleDateFormat(dateFormat);
                Date fDate = df.parse(fromDate);
                Date tDate = df.parse(toDate);
                long diff = tDate.getTime() - fDate.getTime();
                boolean isMinus = false;
                if (diff < 0L) {
                    isMinus = true;
                }
                long diffDays = diff / 86400000L;
                if (isMinus) {
                    return Long.toString(diffDays);
                }
                return Long.toString(diffDays);
            }
            return "-";
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getLastPayedDate(String fromDate, String dateFormat, int month) {
        SimpleDateFormat df = new SimpleDateFormat(dateFormat);
        try {
            Date fDate = df.parse(fromDate);
            return DateConverter.addMonth(fDate, month, df);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getRegistApprovalDate(String registDate) {
        try {
            String initDate = registDate.substring(0, 6) + "01";
            if (logger.isDebugEnabled()) {
                logger.debug("getRegistApprovalDate initDate : {}", (Object)initDate);
            }
            String addTwoMonthDate = DateConverter.addMonth(initDate, DEFAULT_DATE_FORMAT, 2, DEFAULT_DATE_FORMAT);
            if (logger.isDebugEnabled()) {
                logger.debug("getRegistApprovalDate addTwoMonthDate : {}", (Object)addTwoMonthDate);
            }
            SimpleDateFormat df = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
            Date approvalDate = df.parse(addTwoMonthDate);
            String resultStr = DateConverter.addDays(approvalDate, -1, DEFAULT_DATE_FORMAT);
            if (logger.isDebugEnabled()) {
                logger.debug("getRegistApprovalDate resultStr : {}", (Object)resultStr);
            }
            return resultStr;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean valid(String date, String format) {
        if (date == null || date.length() == 0) {
            return false;
        }
        SimpleDateFormat df = new SimpleDateFormat(format, DEFAULT_LOCALE);
        return DateConverter.valid(date, df);
    }

    public static boolean valid(String date, String format, Locale locale) {
        if (date == null || date.length() == 0) {
            return false;
        }
        if (locale == null) {
            locale = DEFAULT_LOCALE;
        }
        SimpleDateFormat df = new SimpleDateFormat(format, locale);
        return DateConverter.valid(date, df);
    }

    public static boolean valid(String date, DateFormat df) {
        Date d = null;
        if (date == null || date.length() == 0) {
            return false;
        }
        try {
            d = df.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
        return df.format(d).equals(date);
    }

    public static boolean before(String date1, String date2, String format) {
        if (date1 == null || date1.length() == 0) {
            return false;
        }
        if (date2 == null || date2.length() == 0) {
            return false;
        }
        if (format == null || format.length() == 0) {
            format = DEFAULT_DATE_FORMAT;
        }
        SimpleDateFormat df = new SimpleDateFormat(format, Locale.KOREA);
        return DateConverter.before(date1, date2, df);
    }

    public static boolean before(String date1, String date2, Locale locale) {
        if (date1 == null || date1.length() == 0) {
            return false;
        }
        if (date2 == null || date2.length() == 0) {
            return false;
        }
        if (locale == null) {
            locale = DEFAULT_LOCALE;
        }
        SimpleDateFormat df = new SimpleDateFormat(DEFAULT_DATE_FORMAT, locale);
        return DateConverter.before(date1, date2, df);
    }

    public static boolean before(String date1, String date2, String format, Locale locale) {
        if (date1 == null || date1.length() == 0) {
            return false;
        }
        if (date2 == null || date2.length() == 0) {
            return false;
        }
        if (format == null || format.length() == 0) {
            format = DEFAULT_DATE_FORMAT;
        }
        if (locale == null) {
            locale = DEFAULT_LOCALE;
        }
        SimpleDateFormat df = new SimpleDateFormat(format, locale);
        return DateConverter.before(date1, date2, df);
    }

    public static boolean before(String date1, String date2, DateFormat df) {
        if (date1 == null || date1.length() == 0) {
            return false;
        }
        if (date2 == null || date2.length() == 0) {
            return false;
        }
        Date d1 = null;
        Date d2 = null;
        try {
            d1 = df.parse(date1);
            d2 = df.parse(date2);
            if (!df.format(d1).equals(date1) || !df.format(d2).equals(date2)) {
                return false;
            }
            return d1.after(d2);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String addDot(String date1) {
        if (date1 == null || date1.length() != 8) {
            return date1;
        }
        return date1.substring(0, 4) + "." + date1.substring(4, 6) + "." + date1.substring(6, 8);
    }

    public static String getDayOfWeek(String date) {
        return DateConverter.getDayOfWeek(date, "ko");
    }

    public static String getDayOfWeek(String date, String locale) {
        if (date == null) {
            return null;
        }
        date = date.replace(".", "");
        date = date.replace("-", "");
        if ((date = date.replace("_", "")).length() < 8) {
            return null;
        }
        int year = Integer.parseInt(date.substring(0, 4));
        int month = Integer.parseInt(date.substring(4, 6)) - 1;
        int dates = Integer.parseInt(date.substring(6, 8));
        GregorianCalendar c = new GregorianCalendar(year, month, dates);
        int dayOfWeek = c.get(7);
        String[] week = DateConverter.getWeekArray(locale);
        return week[dayOfWeek - 1];
    }

    public static String getDayOfWeek(String date, String format, String locale, String timezone) {
        if (date == null || date.length() == 0) {
            return null;
        }
        if (format == null || format.length() == 0) {
            format = DEFAULT_DATE_FORMAT;
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            Date d = df.parse(date);
            if (timezone != null && !timezone.equals("")) {
                timezone = "GMT" + timezone;
            }
            df.setTimeZone(TimeZone.getTimeZone(timezone));
            return DateConverter.getDayOfWeek(df.format(d), locale);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] getWeekArray(String locale) {
        String[] week = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"};
        return week;
    }

    public static String getMonthChartString(String locale) {
        StringBuilder month = new StringBuilder();
        month.append("['1\uc6d4', '2\uc6d4', '3\uc6d4', '4\uc6d4', '5\uc6d4', '6\uc6d4', '7\uc6d4', '8\uc6d4', '9\uc6d4', '10\uc6d4', '11\uc6d4', '12\uc6d4']");
        return month.toString();
    }

    public static String convertMilli2String(long t) {
        return String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(t), TimeUnit.MILLISECONDS.toSeconds(t) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(t)));
    }

    public static String convertSecond2Date(int second) {
        return DateConverter.convertSecond2Date((long)second);
    }

    public static String convertSecond2Date(BigDecimal second) {
        return DateConverter.convertSecond2Date(second.longValue());
    }

    public static String convertSecond2Date(long second) {
        long hh = second / 3600L;
        long mm = second % 3600L / 60L;
        long ss = second % 3600L % 60L;
        return String.format("%02d:%02d:%02d", hh, mm, ss);
    }

    public static String convertSecond2DayTime(String secTime, String dayUnit) {
        long second = Long.parseLong(secTime);
        double day = 0.0;
        if (second >= 86400L) {
            day = Math.floor(second / 86400L);
            second %= 86400L;
        }
        long hh = second / 3600L;
        long mm = second % 3600L / 60L;
        long ss = second % 3600L % 60L;
        if (day > 0.0) {
            return String.format("%d%s %02d:%02d:%02d", (int)day, dayUnit, hh, mm, ss);
        }
        return String.format("%02d:%02d:%02d", hh, mm, ss);
    }

    public static String convertUtcTime(String date, String format, String gmt) {
        if (date == null || date.length() == 0) {
            return null;
        }
        String gmtKey = "UTC";
        if (gmt != null && !gmt.equals("")) {
            gmtKey = "GMT" + gmt;
        }
        if (format == null || format.length() == 0) {
            format = DEFAULT_DATE_FORMAT;
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setTimeZone(TimeZone.getTimeZone(gmtKey));
        Date d = null;
        try {
            d = df.parse(date);
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            return df.format(d);
        }
        catch (ParseException e) {
            logger.error("convertUtcTime error", (Throwable)e);
            return null;
        }
    }

    public static String getUtcCurrentTime() {
        return DateConverter.getUtcCurrentTime("GMT+09:00");
    }

    public static String getUtcBeforeHourTime(int hour) {
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHH");
        TimeZone tz = TimeZone.getTimeZone("UTC");
        df.setTimeZone(tz);
        return df.format(date.getTime() + (long)(3600 * hour * 1000));
    }

    public static String getUtcCurrentTime(String timezone, String format) {
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setTimeZone(TimeZone.getTimeZone(timezone));
        return df.format(date);
    }

    public static String getUtcCurrentTime(String gmt) {
        String gmtKey = "UTC";
        if (gmt != null && !gmt.equals("")) {
            gmtKey = "GMT" + gmt;
        }
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern(DEFAULT_DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone(gmtKey));
        return sdf.format(new Date().getTime());
    }

    public static String getUtcCurrentTime(String gmt, int hour) {
        String gmtKey = "UTC";
        if (gmt != null && !gmt.equals("")) {
            gmtKey = "GMT" + gmt;
        }
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("yyyyMMddHH");
        sdf.setTimeZone(TimeZone.getTimeZone(gmtKey));
        Calendar c = Calendar.getInstance();
        c.add(10, hour);
        Date d = c.getTime();
        return sdf.format(d.getTime());
    }

    public static String changeFileNameType(String format) {
        String changeTerm = "";
        if ((format = format.replace(".", "")).length() != 6) {
            return null;
        }
        changeTerm = format.substring(0, 4);
        int month = Integer.parseInt(format.substring(5));
        switch (month) {
            case 1: {
                changeTerm = changeTerm + "January";
                break;
            }
            case 2: {
                changeTerm = changeTerm + "February";
                break;
            }
            case 3: {
                changeTerm = changeTerm + "March";
                break;
            }
            case 4: {
                changeTerm = changeTerm + "April";
                break;
            }
            case 5: {
                changeTerm = changeTerm + "May";
                break;
            }
            case 6: {
                changeTerm = changeTerm + "June";
                break;
            }
            case 7: {
                changeTerm = changeTerm + "July";
                break;
            }
            case 8: {
                changeTerm = changeTerm + "August";
                break;
            }
            case 9: {
                changeTerm = changeTerm + "September";
                break;
            }
            case 10: {
                changeTerm = changeTerm + "October";
                break;
            }
            case 11: {
                changeTerm = changeTerm + "November";
                break;
            }
            case 12: {
                changeTerm = changeTerm + "December";
                break;
            }
        }
        return changeTerm;
    }

    public static void main(String[] args) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug(DateConverter.getFormattedDate("20120131055010", "yyyyMMddHHmmss", "yyyy.MM.dd HH:mm:ss", "+09:00"));
        }
    }
}

