/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.constrants;

public enum StatusType {
    PENDDING("00"),
    REJECT_APPROVAL("0R"),
    WAIT_APPROVAL("0A"),
    APPROVAL("05"),
    REGIST("10"),
    RESERVE("20"),
    SENDING("30"),
    STOP_SENDING("31"),
    STOP_SEND_COMPLETE("32"),
    MQ_SENDING("37"),
    CCS_SENDING("38"),
    REGIST_RESEND("35"),
    RESEND("36"),
    COMPLETE("40"),
    ERROR("41"),
    DENY("50"),
    FATIGUE_FILTER_RESERVE("60"),
    FATIGUE_FILTER_ON("61"),
    FATIGUE_FILTER_COMPLETE("62"),
    REGIST_RESEND_ERROR("45"),
    TARGETING("90"),
    DELETE("99");

    final String status;

    private StatusType(String status) {
        this.status = status;
    }

    public String getCode() {
        return this.status;
    }

    public boolean same(String status) {
        return this.getCode().equals(status);
    }

    public static String findStatusCode(String code) {
        if (code == null) {
            return null;
        }
        String value = null;
        for (StatusType status : StatusType.values()) {
            value = status.getCode();
            if (code.indexOf(value) < 0) continue;
            return value;
        }
        return null;
    }

    public static boolean isIn(String code, StatusType ... statusTypes) {
        if (code == null) {
            return false;
        }
        for (StatusType s : statusTypes) {
            if (!s.same(code)) continue;
            return true;
        }
        return true;
    }
}

