/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.constrants;

public enum TargetStatus {
    RESERVE("T1"),
    CANCEL("T3"),
    CANCEL_COMPLETE("T4"),
    RUNNING("90"),
    ERROR("95"),
    COMPLETE("TC"),
    SPOOL_ERROR("96");

    final String status;

    private TargetStatus(String status) {
        this.status = status;
    }

    public String getCode() {
        return this.status;
    }

    public boolean same(String status) {
        return this.getCode().equals(status);
    }

    public static String findStatusCode(String code) {
        if (code == null) {
            return null;
        }
        String value = null;
        for (TargetStatus status : TargetStatus.values()) {
            value = status.getCode();
            if (code.indexOf(value) < 0) continue;
            return value;
        }
        return null;
    }

    public static boolean isIn(String code, TargetStatus ... targetStatuses) {
        if (code == null) {
            return false;
        }
        for (TargetStatus s : targetStatuses) {
            if (!s.same(code)) continue;
            return true;
        }
        return true;
    }
}

