/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.common.xml;

import java.io.OutputStream;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlWriter {
    private static final byte[] __NEW_LINE = System.getProperty("line.separator").getBytes();
    private static final byte[] __TAB = "\t".getBytes();
    private static final byte[] __TAG_OPEN = "<".getBytes();
    private static final byte[] __END_TAG_OPEN = "</".getBytes();
    private static final byte[] __TAG_CLOSE = ">".getBytes();
    private static final byte[] __NO_CHILD_TAG_CLOSE = "/>".getBytes();
    private static final byte[] __ATTR_OPEN = "=\"".getBytes();
    private static final byte[] __ATTR_CLOSE = "\"".getBytes();
    private static final byte[] __BLANK = " ".getBytes();
    private static final byte[] __PROCESSING_INSTRUCTION_NODE_OPEN = "<?".getBytes();
    private static final byte[] __PROCESSING_INSTRUCTION_NODE_CLOSE = "?>".getBytes();
    private static final byte[] __N_PERCENT = "&".getBytes();
    private static final byte[] __SEMICOLON = ";".getBytes();
    private static final byte[] __CDATA_OPEN = "<![CDATA[".getBytes();
    private static final byte[] __CDATA_CLOSE = "]]>".getBytes();
    private String PRINTWRITER_ENCODING = "euc-kr";
    private boolean canonical = false;
    private OutputStream STREAM = null;
    private String OUT_CHARSET = null;
    private String DTDFile = null;
    private StringBuffer __INNER_WORK_BUFFER = new StringBuffer(256);

    public void outResult(OutputStream __STREAM, String __OUT_CHARSET, Document myDoc, String df) throws Exception {
        this.DTDFile = df;
        this.STREAM = __STREAM;
        this.OUT_CHARSET = __OUT_CHARSET;
        this.println("<?xml version=\"1.0\" encoding=\"" + this.getWriterEncoding() + "\"?>");
        Node node = myDoc.getFirstChild();
        if (node.getNodeType() == 1) {
            this.println("<!DOCTYPE " + ((Element)node).getTagName() + " SYSTEM \"" + this.DTDFile + "\">");
        }
        this.print(myDoc, 0);
    }

    public void setEncoding(String enc) {
        this.PRINTWRITER_ENCODING = enc;
    }

    public void setCanonical(boolean can) {
        this.canonical = can;
    }

    private Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        for (int i = 0; i < len; ++i) {
            array[i] = (Attr)attrs.item(i);
        }
        return array;
    }

    private void println(String s) throws Exception {
        this.print(s);
        this.newLine();
    }

    private void print(String s) throws Exception {
        this.print(s.getBytes(this.OUT_CHARSET));
    }

    private void print(byte[] source) throws Exception {
        this.STREAM.write(source);
    }

    private void newLine() throws Exception {
        this.print(__NEW_LINE);
        this.STREAM.flush();
    }

    private void print(Node node, int depth) throws Exception {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        boolean __HAS_CHILD__ = false;
        switch (type) {
            case 9: {
                NodeList children = node.getChildNodes();
                for (int iChild = 0; iChild < children.getLength(); ++iChild) {
                    this.print(children.item(iChild), depth);
                }
                this.STREAM.flush();
                break;
            }
            case 10: {
                this.println("<!DOCTYPE " + ((DocumentType)node).getName() + " SYSTEM \"" + this.DTDFile + "\">");
                break;
            }
            case 1: {
                for (int k = 0; k < depth; ++k) {
                    this.print(__TAB);
                }
                this.print(__TAG_OPEN);
                this.print(node.getNodeName());
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                for (int i = 0; i < attrs.length; ++i) {
                    Attr attr = attrs[i];
                    this.print(__BLANK);
                    this.print(attr.getNodeName());
                    this.print(__ATTR_OPEN);
                    this.print(this.normalize(attr.getNodeValue()));
                    this.print(__ATTR_CLOSE);
                }
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                if (len > 0) {
                    __HAS_CHILD__ = true;
                    this.print(__TAG_CLOSE);
                    this.newLine();
                    for (int i = 0; i < len; ++i) {
                        this.print(children.item(i), depth + 1);
                    }
                    break;
                }
                __HAS_CHILD__ = false;
                this.print(__NO_CHILD_TAG_CLOSE);
                this.newLine();
                break;
            }
            case 5: {
                if (this.canonical) {
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    int len = children.getLength();
                    for (int i = 0; i < len; ++i) {
                        this.print(children.item(i), depth + 1);
                    }
                    break;
                }
                this.print(__N_PERCENT);
                this.print(node.getNodeName());
                this.print(__SEMICOLON);
                break;
            }
            case 4: {
                for (int k = 0; k < depth; ++k) {
                    this.print(__TAB);
                }
                if (this.canonical) {
                    this.print(this.normalize(node.getNodeValue()));
                    break;
                }
                this.print(__CDATA_OPEN);
                this.print(node.getNodeValue());
                this.print(__CDATA_CLOSE);
                this.newLine();
                break;
            }
            case 3: {
                String nodeValue = node.getNodeValue();
                if (nodeValue.trim().length() == 0) break;
                for (int k = 0; k < depth; ++k) {
                    this.print(__TAB);
                }
                this.print(this.normalize(nodeValue));
                this.newLine();
                break;
            }
            case 7: {
                for (int k = 0; k < depth; ++k) {
                    this.print(__TAB);
                }
                this.print(__PROCESSING_INSTRUCTION_NODE_OPEN);
                this.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    this.print(__BLANK);
                    this.print(data);
                }
                this.print(__PROCESSING_INSTRUCTION_NODE_CLOSE);
                this.newLine();
                break;
            }
        }
        if (type == 1 && __HAS_CHILD__) {
            for (int k = 0; k < depth; ++k) {
                this.print(__TAB);
            }
            this.print(__END_TAG_OPEN);
            this.print(node.getNodeName());
            this.print(__TAG_CLOSE);
            this.newLine();
        }
        this.STREAM.flush();
    }

    private synchronized String normalize(String s) {
        this.__INNER_WORK_BUFFER.setLength(0);
        int len = s != null ? s.length() : 0;
        block8: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    this.__INNER_WORK_BUFFER.append("&lt;");
                    continue block8;
                }
                case '>': {
                    this.__INNER_WORK_BUFFER.append("&gt;");
                    continue block8;
                }
                case '&': {
                    this.__INNER_WORK_BUFFER.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    this.__INNER_WORK_BUFFER.append("&quot;");
                    continue block8;
                }
                case '\n': 
                case '\r': {
                    if (this.canonical) {
                        this.__INNER_WORK_BUFFER.append("&#");
                        this.__INNER_WORK_BUFFER.append(Integer.toString(ch));
                        this.__INNER_WORK_BUFFER.append(';');
                        continue block8;
                    }
                }
                case '\\': {
                    this.__INNER_WORK_BUFFER.append("\\\\");
                    continue block8;
                }
                default: {
                    this.__INNER_WORK_BUFFER.append(ch);
                }
            }
        }
        return this.__INNER_WORK_BUFFER.toString();
    }

    private String getWriterEncoding() {
        return this.PRINTWRITER_ENCODING;
    }
}

