/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.service.impl;

import com.humuson.tms.common.security.HumusonDecryptor;
import com.humuson.tms.common.security.HumusonEncryptor;
import com.humuson.tms.exception.MemberFieldDecryptException;
import com.humuson.tms.service.MemberFieldSecurityService;
import org.springframework.beans.factory.annotation.Value;

public class MemberFieldSecurityServiceImpl
implements MemberFieldSecurityService {
    @Value(value="${db.enc.key:#{null}}")
    String encKey;

    public MemberFieldSecurityServiceImpl() {
    }

    public MemberFieldSecurityServiceImpl(String encKey) {
        this.encKey = encKey;
    }

    @Override
    public String encrypt(String type, String str) {
        return HumusonEncryptor.encrypt(str, this.encKey, false);
    }

    @Override
    public String encrypt(String str) {
        return this.encrypt(null, str);
    }

    @Override
    public String decrypt(String type, String str) {
        String s = null;
        try {
            s = HumusonDecryptor.decrypt(str, this.encKey, false);
        }
        catch (Exception e) {
            throw new MemberFieldDecryptException(e);
        }
        return s;
    }

    @Override
    public String decrypt(String str) {
        return this.decrypt(null, str);
    }

    @Override
    public void changeEncKey(String encKey) {
        this.encKey = encKey;
    }

    @Override
    public String getEncKey() {
        return this.encKey;
    }
}

