/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.constrants;

import com.humuson.tms.constrants.RoleType;

public enum TmsUserAuth {
    Administrator("001", new RoleType[]{RoleType.SEND, RoleType.APPROVAL, RoleType.SITE_MGR, RoleType.ACC_MGR, RoleType.SYS_MGR, RoleType.VIEW_ALL, RoleType.ADMIN}, "\uc288\ud37c\uad00\ub9ac\uc790"),
    Manager("002", new RoleType[]{RoleType.SEND, RoleType.APPROVAL, RoleType.ACC_MGR, RoleType.VIEW_DEPT}, "\ubd80\uc11c\uad00\ub9ac\uc790"),
    NormalUser("003", new RoleType[]{RoleType.VIEW_USER}, "\uc77c\ubc18\uc0ac\uc6a9\uc790"),
    UnAuthorizedUser("-1", new RoleType[0], "\ube44\uc778\uc99d \uc0ac\uc6a9\uc790"),
    ServiceUser("100", new RoleType[]{RoleType.VIEW_USER}, "\uc77c\ubc18\uc720\uc800"),
    CustomUser("200", new RoleType[0], "custom user");

    static final TmsUserAuth[] MANAGET_LIST;
    final String code;
    final RoleType[] roles;
    final String desc;

    private TmsUserAuth(String code, RoleType[] roles, String desc) {
        this.code = code;
        this.roles = roles;
        this.desc = desc;
    }

    public String getCode() {
        return this.code;
    }

    public RoleType[] getRoles() {
        return this.roles;
    }

    public String getDesc() {
        return this.desc;
    }

    public static boolean isAdministrator(String authId) {
        return Administrator.same(authId);
    }

    public static boolean isManager(String authId) {
        return Manager.same(authId);
    }

    public static boolean checkHaveManagerOrHigherAuth(String authId) {
        for (TmsUserAuth userAuth : MANAGET_LIST) {
            if (!userAuth.same(authId)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNormalUser(String authId) {
        return NormalUser.same(authId);
    }

    public static boolean isUnAuthorizedUser(String authId) {
        return UnAuthorizedUser.same(authId);
    }

    public static boolean isCustomUser(String authId) {
        return CustomUser.same(authId);
    }

    protected boolean same(String authId) {
        return this.getCode().equals(authId);
    }

    public static TmsUserAuth findUserAuthByCode(String code) {
        for (TmsUserAuth userAuth : TmsUserAuth.values()) {
            if (!userAuth.same(code)) continue;
            return userAuth;
        }
        return null;
    }

    static {
        MANAGET_LIST = new TmsUserAuth[]{Administrator, Manager};
    }
}

