/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XLSX2CSV {
    private static final Logger logger = LoggerFactory.getLogger(XLSX2CSV.class);
    private OPCPackage xlsxPackage;
    private int minColumns;
    private PrintStream output;

    public XLSX2CSV(OPCPackage pkg, PrintStream output, int minColumns) {
        this.xlsxPackage = pkg;
        this.output = output;
        this.minColumns = minColumns;
        if (logger.isDebugEnabled()) {
            logger.debug("minColumns :{}", (Object)minColumns);
        }
    }

    public void processSheet(ReadOnlySharedStringsTable sst, InputStream sheetInputStream) throws IOException, ParserConfigurationException, SAXException {
        InputSource sheetSource = new InputSource(sheetInputStream);
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = saxFactory.newSAXParser();
        XMLReader sheetParser = saxParser.getXMLReader();
        MyXSSFSheetHandler handler = new MyXSSFSheetHandler(sst, this.minColumns, this.output);
        sheetParser.setContentHandler(handler);
        sheetParser.parse(sheetSource);
    }

    public void process() throws IOException, OpenXML4JException, ParserConfigurationException, SAXException {
        ReadOnlySharedStringsTable sst = new ReadOnlySharedStringsTable(this.xlsxPackage);
        XSSFReader xssfReader = new XSSFReader(this.xlsxPackage);
        XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
        while (iter.hasNext()) {
            InputStream stream = iter.next();
            this.processSheet(sst, stream);
            stream.close();
        }
    }

    class MyXSSFSheetHandler
    extends DefaultHandler {
        private ReadOnlySharedStringsTable sharedStringsTable;
        private final PrintStream output;
        private final int minColumnCount;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("M/d/yyyy");
        SimpleDateFormat simpleTimeFormat = new SimpleDateFormat("hh:mm:ss a");
        private boolean vIsOpen;
        private xssfDataType nextDataType;
        private int thisColumn = -1;
        private int lastColumnNumber = -1;
        private StringBuffer contents;

        public MyXSSFSheetHandler(ReadOnlySharedStringsTable sst, int cols, PrintStream target) {
            this.sharedStringsTable = sst;
            this.minColumnCount = cols;
            this.output = target;
            this.contents = new StringBuffer();
            this.nextDataType = xssfDataType.SSTINDEX;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if ("c".equals(name)) {
                String r = attributes.getValue("r");
                int firstDigit = -1;
                for (int c = 0; c < r.length(); ++c) {
                    if (!Character.isDigit(r.charAt(c))) continue;
                    firstDigit = c;
                    break;
                }
                this.thisColumn = this.nameToColumn(r.substring(0, firstDigit));
                String cellType = attributes.getValue("t");
                String cellSomething = attributes.getValue("s");
                this.nextDataType = "b".equals(cellType) ? xssfDataType.BOOL : ("e".equals(cellType) ? xssfDataType.FORMULA : ("s".equals(cellType) ? xssfDataType.SSTINDEX : ("2".equals(cellSomething) ? xssfDataType.DATE : ("3".equals(cellSomething) ? xssfDataType.TIME : ("4".equals(cellSomething) ? xssfDataType.DATETIME : xssfDataType.NUMBER)))));
            } else if ("v".equals(name)) {
                this.vIsOpen = true;
                this.contents.setLength(0);
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            String thisStr = null;
            if ("v".equals(name)) {
                switch (this.nextDataType) {
                    case SSTINDEX: {
                        String sstIndex = this.contents.toString();
                        try {
                            int idx = Integer.parseInt(sstIndex);
                            XSSFRichTextString rts = new XSSFRichTextString(this.sharedStringsTable.getEntryAt(idx));
                            thisStr = rts.toString();
                        }
                        catch (NumberFormatException ex) {
                            this.output.println("Pgmr err, lastContents is not int: " + sstIndex);
                        }
                        break;
                    }
                    case FORMULA: {
                        thisStr = '\"' + this.contents.toString() + '\"';
                        break;
                    }
                    case NUMBER: {
                        thisStr = this.contents.toString();
                        break;
                    }
                    default: {
                        thisStr = this.contents.toString();
                    }
                }
                if (this.lastColumnNumber == -1) {
                    this.lastColumnNumber = 0;
                }
                for (int i = this.lastColumnNumber; i < this.thisColumn; ++i) {
                    this.output.print(',');
                }
                this.output.print(thisStr);
                if (this.thisColumn > -1) {
                    this.lastColumnNumber = this.thisColumn;
                }
            } else if ("row".equals(name)) {
                if (XLSX2CSV.this.minColumns > 0) {
                    if (this.lastColumnNumber == -1) {
                        this.lastColumnNumber = 0;
                    }
                    for (int i = this.lastColumnNumber; i < this.minColumnCount; ++i) {
                        this.output.print(',');
                    }
                }
                this.output.println();
                this.lastColumnNumber = -1;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.vIsOpen) {
                this.contents.append(ch, start, length);
            }
        }

        private int nameToColumn(String name) {
            int column = -1;
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                column = (column + 1) * 26 + c - 65;
            }
            return column;
        }
    }

    static enum xssfDataType {
        BOOL,
        DATE,
        DATETIME,
        FORMULA,
        SSTINDEX,
        TIME,
        NUMBER;

    }
}

