/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.common.util;

import org.apache.commons.io.FilenameUtils;

public class FileExtentionUtil {
    public static final String[] RESTRICTED_EXTENTIONS = new String[]{"jsp", "asp", "cgi", "php", "php3", "inc", "pl"};
    public static final String[] IMAGE_FILE_EXTENTIONS = new String[]{"gif", "png", "jpg", "jpeg"};
    public static final String[] TARGETING_FILE_EXTENTIONS = new String[]{"txt", "csv", "xls", "xlsx"};
    public static final String[] P12_FILE_EXTENTIONS = new String[]{"p12"};

    public static boolean isValidExtention(String fileName) {
        return !FilenameUtils.isExtension((String)(fileName = fileName.toLowerCase()), (String[])RESTRICTED_EXTENTIONS);
    }

    public static boolean isImageFileExtention(String fileName) {
        if (FileExtentionUtil.isValidExtention(fileName = fileName.toLowerCase())) {
            return FilenameUtils.isExtension((String)fileName, (String[])IMAGE_FILE_EXTENTIONS);
        }
        return false;
    }

    public static boolean isTargetingFileExtention(String fileName) {
        if (FileExtentionUtil.isValidExtention(fileName = fileName.toLowerCase())) {
            return FilenameUtils.isExtension((String)fileName, (String[])TARGETING_FILE_EXTENTIONS);
        }
        return false;
    }

    public static boolean isP12FileExtention(String fileName) {
        if (FileExtentionUtil.isValidExtention(fileName = fileName.toLowerCase())) {
            return FilenameUtils.isExtension((String)fileName, (String[])P12_FILE_EXTENTIONS);
        }
        return false;
    }
}

