/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.common.util;

import com.humuson.tms.common.security.HumusonDecryptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.DefaultPropertiesPersister;
import org.springframework.util.StringUtils;

public class DecryptPropertiesPersister
extends DefaultPropertiesPersister {
    private Logger logger = LoggerFactory.getLogger(DecryptPropertiesPersister.class);
    private static final String PREFIX_ENCRYPT = "enc.";
    private static final String SURFIX_PASSWORD = ".password";
    private String encryptKey;

    public void load(Properties props, Reader reader) throws IOException {
        this.doLoad(props, reader);
    }

    protected void doLoad(Properties props, Reader reader) throws IOException {
        BufferedReader in = new BufferedReader(reader);
        String line;
        while ((line = in.readLine()) != null) {
            char firstChar;
            if ((line = StringUtils.trimLeadingWhitespace((String)line)).length() <= 0 || (firstChar = line.charAt(0)) == '#' || firstChar == '!') continue;
            while (this.endsWithContinuationMarker(line)) {
                String nextLine = in.readLine();
                line = line.substring(0, line.length() - 1);
                if (nextLine == null) continue;
                line = line + StringUtils.trimLeadingWhitespace((String)nextLine);
            }
            int separatorIndex = line.indexOf("=");
            if (separatorIndex == -1) {
                separatorIndex = line.indexOf(":");
            }
            String key = separatorIndex != -1 ? line.substring(0, separatorIndex) : line;
            String value = separatorIndex != -1 ? line.substring(separatorIndex + 1) : "";
            key = StringUtils.trimTrailingWhitespace((String)key);
            value = StringUtils.trimLeadingWhitespace((String)value);
            try {
                if (key.startsWith(PREFIX_ENCRYPT) && key.endsWith(SURFIX_PASSWORD)) {
                    this.logger.info("before key :{}, value:{}", (Object)key, (Object)value);
                    value = this.encryptKey != null && !"".equals(this.encryptKey) ? HumusonDecryptor.decrypt(value, this.encryptKey) : HumusonDecryptor.decrypt(value);
                    this.logger.info("after key :{}, value:{}", (Object)key, (Object)value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error("decrypr fail", (Throwable)e);
            }
            props.put(this.unescape(key), this.unescape(value));
        }
        return;
    }

    public void setEncryptKey(String encryptKey) {
        this.encryptKey = encryptKey;
    }
}

