/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.common.lang;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Locale {
    private static final Logger log = LoggerFactory.getLogger(Locale.class);
    public static String CHAR_SET = "KSC5601";
    public static String FILE_IN_CHAR_SET = "KSC5601";
    public static String FILE_OUT_CHAR_SET = "KSC5601";
    public static String WEB_IN_CHAR_SET = "KSC5601";
    public static String WEB_OUT_CHAR_SET = "KSC5601";
    public static String WEB_DOWNLOAD_CHAR_SET = "KSC5601";
    public static String DB_BASE_CHAR_SET = "KSC5601";
    public static String DB_IN_CHAR_SET = "KSC5601";
    public static String DB_OUT_CHAR_SET = "KSC5601";
    public static String RESPONSE_CONTENT_TYPE = "text/html; charset=euc-kr";
    public static String RESPONSE_CHARSET = "KSC5601";
    public static String REQUEST_CHARSET = "KSC5601";
    public static boolean FILE_IN_CONVERT_FLAG = false;
    public static boolean FILE_OUT_CONVERT_FLAG = false;
    public static boolean WEB_IN_CONVERT_FLAG = false;
    public static boolean WEB_OUT_CONVERT_FLAG = false;
    public static boolean DB_IN_CONVERT_FLAG = false;
    public static boolean DB_OUT_CONVERT_FLAG = false;
    public static boolean UNICODE_CONVERT_FLAG = false;

    public static synchronized void initialize(Object obj) throws Exception {
        if (obj instanceof Properties) {
            Properties prop = (Properties)obj;
            CHAR_SET = prop.getProperty("system.charset", "KSC5601");
            FILE_IN_CHAR_SET = prop.getProperty("file.in.charset", CHAR_SET);
            FILE_OUT_CHAR_SET = prop.getProperty("file.out.charset", CHAR_SET);
            WEB_IN_CHAR_SET = prop.getProperty("web.in.charset", CHAR_SET);
            WEB_OUT_CHAR_SET = prop.getProperty("web.out.charset", CHAR_SET);
            WEB_DOWNLOAD_CHAR_SET = prop.getProperty("web.download.charset", CHAR_SET);
            DB_BASE_CHAR_SET = prop.getProperty("db.base.charset", CHAR_SET);
            DB_IN_CHAR_SET = prop.getProperty("db.in.charset", CHAR_SET);
            DB_OUT_CHAR_SET = prop.getProperty("db.out.charset", CHAR_SET);
            RESPONSE_CONTENT_TYPE = prop.getProperty("response.content.type", RESPONSE_CONTENT_TYPE);
            RESPONSE_CHARSET = prop.getProperty("response.charset", RESPONSE_CONTENT_TYPE);
            REQUEST_CHARSET = prop.getProperty("request.charset", RESPONSE_CONTENT_TYPE);
            if (log.isDebugEnabled()) {
                System.out.println("action content type :" + RESPONSE_CONTENT_TYPE);
            }
        } else {
            throw new Exception("wrongly used, argument should be 'Properties'");
        }
        FILE_IN_CONVERT_FLAG = CHAR_SET.equalsIgnoreCase(FILE_IN_CHAR_SET);
        FILE_OUT_CONVERT_FLAG = CHAR_SET.equalsIgnoreCase(FILE_OUT_CHAR_SET);
        WEB_IN_CONVERT_FLAG = CHAR_SET.equalsIgnoreCase(WEB_IN_CHAR_SET);
        WEB_OUT_CONVERT_FLAG = CHAR_SET.equalsIgnoreCase(WEB_OUT_CHAR_SET);
        DB_IN_CONVERT_FLAG = DB_BASE_CHAR_SET.equalsIgnoreCase(DB_IN_CHAR_SET);
        DB_OUT_CONVERT_FLAG = DB_BASE_CHAR_SET.equalsIgnoreCase(DB_OUT_CHAR_SET);
        UNICODE_CONVERT_FLAG = CHAR_SET.equalsIgnoreCase("8859_1");
    }

    public static String toWeb(String src) {
        if (src == null) {
            return "";
        }
        if (WEB_OUT_CONVERT_FLAG) {
            return src;
        }
        try {
            return new String(src.getBytes(CHAR_SET), WEB_OUT_CHAR_SET);
        }
        catch (Exception e) {
            return src;
        }
    }

    public static String fromWeb(String src) {
        if (src == null) {
            return "";
        }
        if (WEB_IN_CONVERT_FLAG) {
            return src;
        }
        try {
            return new String(src.getBytes(WEB_IN_CHAR_SET), CHAR_SET);
        }
        catch (Exception e) {
            return src;
        }
    }

    public static String toDb(String src) {
        if (log.isDebugEnabled() && !DB_OUT_CONVERT_FLAG) {
            System.out.println("db to convert src:" + src);
        }
        if (src == null) {
            return "";
        }
        if (DB_IN_CONVERT_FLAG) {
            return src;
        }
        try {
            if (log.isDebugEnabled()) {
                String returnValue = new String(src.getBytes(DB_IN_CHAR_SET), DB_BASE_CHAR_SET);
                System.out.println("db to convert result:" + returnValue);
                return returnValue;
            }
            return new String(src.getBytes(DB_IN_CHAR_SET), DB_BASE_CHAR_SET);
        }
        catch (Exception e) {
            return src;
        }
    }

    public static String fromDb(String src) {
        if (log.isDebugEnabled() && !DB_IN_CONVERT_FLAG) {
            System.out.println("db from convert src:" + src);
        }
        if (src == null) {
            return "";
        }
        if (DB_OUT_CONVERT_FLAG) {
            return src;
        }
        try {
            if (log.isDebugEnabled()) {
                String returnValue = new String(src.getBytes(DB_BASE_CHAR_SET), DB_OUT_CHAR_SET);
                System.out.println("db from convert result:" + returnValue);
                return returnValue;
            }
            return new String(src.getBytes(DB_BASE_CHAR_SET), DB_OUT_CHAR_SET);
        }
        catch (Exception e) {
            return src;
        }
    }

    public static String toFile(String src) {
        if (src == null) {
            return "";
        }
        if (FILE_OUT_CONVERT_FLAG) {
            return src;
        }
        try {
            return new String(src.getBytes(CHAR_SET), FILE_OUT_CHAR_SET);
        }
        catch (Exception e) {
            return src;
        }
    }

    public static String fromFile(String src) {
        if (src == null) {
            return "";
        }
        if (FILE_IN_CONVERT_FLAG) {
            return src;
        }
        try {
            return new String(src.getBytes(FILE_IN_CHAR_SET), CHAR_SET);
        }
        catch (Exception e) {
            return src;
        }
    }

    public static String toUnicode(String src) {
        if (src == null) {
            return "";
        }
        if (UNICODE_CONVERT_FLAG) {
            return src;
        }
        try {
            return new String(src.getBytes(CHAR_SET), "8859_1");
        }
        catch (Exception e) {
            return src;
        }
    }

    public static String debugString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" CHAR_SET = ");
        sb.append(CHAR_SET);
        sb.append(" , FILE_IN_CHAR_SET = ");
        sb.append(FILE_IN_CHAR_SET);
        sb.append(" , FILE_OUT_CHAR_SET = ");
        sb.append(FILE_OUT_CHAR_SET);
        sb.append(" , WEB_IN_CHAR_SET = ");
        sb.append(WEB_IN_CHAR_SET);
        sb.append(" , WEB_OUT_CHAR_SET = ");
        sb.append(WEB_OUT_CHAR_SET);
        sb.append(" , DB_IN_CHAR_SET = ");
        sb.append(DB_IN_CHAR_SET);
        sb.append(" , DB_OUT_CHAR_SET = ");
        sb.append(DB_OUT_CHAR_SET);
        return sb.toString();
    }

    public static String getCHAR_SET() {
        return CHAR_SET;
    }

    public static String getDB_IN_CHAR_SET() {
        return DB_IN_CHAR_SET;
    }

    public static String getDB_OUT_CHAR_SET() {
        return DB_OUT_CHAR_SET;
    }

    public static String getFILE_IN_CHAR_SET() {
        return FILE_IN_CHAR_SET;
    }

    public static String getFILE_OUT_CHAR_SET() {
        return FILE_OUT_CHAR_SET;
    }

    public static String getWEB_IN_CHAR_SET() {
        return WEB_IN_CHAR_SET;
    }

    public static String getWEB_OUT_CHAR_SET() {
        return WEB_OUT_CHAR_SET;
    }

    public static void setCHAR_SET(String string) {
        CHAR_SET = string;
    }

    public static void setDB_IN_CHAR_SET(String string) {
        DB_IN_CHAR_SET = string;
    }

    public static void setDB_OUT_CHAR_SET(String string) {
        DB_OUT_CHAR_SET = string;
    }

    public static void setFILE_IN_CHAR_SET(String string) {
        FILE_IN_CHAR_SET = string;
    }

    public static void setFILE_OUT_CHAR_SET(String string) {
        FILE_OUT_CHAR_SET = string;
    }

    public static void setWEB_IN_CHAR_SET(String string) {
        WEB_IN_CHAR_SET = string;
    }

    public static void setWEB_OUT_CHAR_SET(String string) {
        WEB_OUT_CHAR_SET = string;
    }
}

