/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.constrants;

public enum ChannelType {
    EMAIL("EM", "Email"),
    KAKAO("KA", "KakaoTalk"),
    PUSH("PU", "Push"),
    SMS("SM", "SMS"),
    TOTAL("TO", "Total"),
    TWITTER("TW", "Twitter"),
    FACEBOOK("FB", "Facebook");

    final String code;
    final String name;

    private ChannelType(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public boolean same(String channelTypeCode) {
        return this.getCode().equals(channelTypeCode);
    }

    public static ChannelType valueOfCode(String code) throws IllegalArgumentException {
        for (ChannelType eCode : ChannelType.values()) {
            if (!eCode.getCode().equals(code)) continue;
            return eCode;
        }
        throw new IllegalArgumentException("No enum constant " + code);
    }

    public static String findName(String code) {
        for (ChannelType channelType : ChannelType.values()) {
            if (!channelType.code.equals(code)) continue;
            return channelType.name;
        }
        return null;
    }

    public static String findChannelTypeCode(String str) {
        if (str == null) {
            return null;
        }
        String typeValue = null;
        for (ChannelType channelType : ChannelType.values()) {
            typeValue = channelType.getCode();
            if (str.indexOf(typeValue) < 0) continue;
            return typeValue;
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(ChannelType.valueOfCode("PU").getCode());
    }
}

