/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.common.util;

import com.humuson.tms.common.util.XLSX2CSV;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ExcelDataConvertor {
    private static final String NEW_LINE_CHARACTER = "\r\n";
    private static final String CVS_SEPERATOR_CHAR = ",";

    public static void csvToEXCEL(String csvFileName, String excelFileName) throws Exception {
        ExcelDataConvertor.checkValidFile(csvFileName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(csvFileName)));
        HSSFWorkbook workBook = new HSSFWorkbook();
        FileOutputStream writer = new FileOutputStream(new File(excelFileName));
        HSSFSheet sheet = workBook.createSheet();
        String line = "";
        int rowNo = 0;
        while ((line = reader.readLine()) != null) {
            String[] columns = line.split(CVS_SEPERATOR_CHAR);
            HSSFRow row = sheet.createRow(rowNo);
            for (int i = 0; i < columns.length; ++i) {
                HSSFCell cell = row.createCell(i);
                cell.setCellValue(columns[i]);
            }
            ++rowNo;
        }
        workBook.write((OutputStream)writer);
        writer.close();
        reader.close();
    }

    public static void XSLXToCSV(String excelFileName, String csvFileName) throws Exception {
        ExcelDataConvertor.XSLXToCSV(excelFileName, csvFileName, "EUC-KR");
    }

    public static void XSLXToCSV(String excelFileName, String csvFileName, String charSet) throws Exception {
        ExcelDataConvertor.XSLXToCSV(excelFileName, csvFileName, charSet, CVS_SEPERATOR_CHAR);
    }

    public static void XSLXToCSV(String excelFileName, String csvFileName, String charSet, String delim) throws Exception {
        if (!ExcelDataConvertor.checkValidFile(excelFileName)) {
            throw new Exception("The excel file name is not valid!!!");
        }
        OPCPackage p = OPCPackage.open((String)excelFileName, (PackageAccess)PackageAccess.READ);
        XLSX2CSV xlsx2csv = new XLSX2CSV(p, new PrintStream(csvFileName, charSet), 2);
        xlsx2csv.process();
        p.revert();
    }

    public static void XSLToCSV(String excelFileName, String csvFileName) throws Exception {
        ExcelDataConvertor.XSLToCSV(excelFileName, csvFileName, "EUC-KR");
    }

    public static void XSLToCSV(String excelFileName, String csvFileName, String charSet) throws Exception {
        ExcelDataConvertor.XSLToCSV(excelFileName, csvFileName, charSet, CVS_SEPERATOR_CHAR);
    }

    public static void XSLToCSV(String excelFileName, String csvFileName, String charSet, String delim) throws Exception {
        if (!ExcelDataConvertor.checkValidFile(excelFileName)) {
            throw new Exception("The excel file name is not valid!!!");
        }
        HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem((InputStream)new FileInputStream(excelFileName)));
        HSSFSheet sheet = workBook.getSheetAt(0);
        Iterator rowIter = sheet.rowIterator();
        StringBuilder scvData = new StringBuilder();
        BufferedWriter outFile = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csvFileName), charSet));
        int cnt = 0;
        while (rowIter.hasNext()) {
            if (cnt > 0) {
                outFile.write(NEW_LINE_CHARACTER);
            }
            HSSFRow row = (HSSFRow)rowIter.next();
            scvData.setLength(0);
            for (int i = 0; i < row.getLastCellNum(); ++i) {
                if (row.getCell(i).getCellType() == 0) {
                    scvData.append(Long.toString((long)row.getCell(i).getNumericCellValue()));
                } else {
                    scvData.append(row.getCell(i).getStringCellValue());
                }
                scvData.append(delim);
            }
            outFile.write(scvData.substring(0, scvData.length() - 1).toString());
            ++cnt;
        }
        ((Writer)outFile).close();
    }

    private static boolean checkValidFile(String fileName) {
        boolean valid = true;
        try {
            File f = new File(fileName);
            if (!f.exists() || f.isDirectory()) {
                valid = false;
            }
        }
        catch (Exception e) {
            valid = false;
        }
        return valid;
    }

    public static void main(String[] arg) {
        String targetFilePath = "/Users/hyogun/workspace/01.android/pms-commons/target.xlsx";
        String targetFileDstPath = "/Users/hyogun/workspace/01.android/pms-commons/target.csv";
        try {
            ExcelDataConvertor.XSLXToCSV(targetFilePath, targetFileDstPath, "EUC-KR");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("end");
    }
}

