/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.common.security;

import com.humuson.tms.common.security.Seed;
import com.humuson.tms.common.zip.HumusonZip;
import org.apache.xmlbeans.impl.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumusonEncryptor {
    private static final Logger logger = LoggerFactory.getLogger(HumusonEncryptor.class);
    private static String FREEKEY = "Pg-s_E_n_C_k_e_y";

    public static String generateKey(String key) {
        String genKey = null;
        genKey = key == null ? FREEKEY.substring(0, 16) : (key.length() > 16 ? key.substring(0, 16) : key + FREEKEY.substring(0, 16 - key.length()));
        return genKey;
    }

    public static String encrypt(String str) {
        return HumusonEncryptor.encrypt(str, FREEKEY, "UTF-8");
    }

    public static String encrypt(String str, String userKey) {
        return HumusonEncryptor.encrypt(str, userKey, "UTF-8", true);
    }

    public static String encrypt(String str, String userKey, boolean useZip) {
        return HumusonEncryptor.encrypt(str, userKey, "UTF-8", useZip);
    }

    public static String encrypt(String str, String userKey, String charSet) {
        return HumusonEncryptor.encrypt(str, userKey, "UTF-8", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encrypt(String str, String userKey, String charSet, boolean useZip) {
        String returnStr = "";
        if (str == null || userKey == null || charSet == null) {
            return returnStr;
        }
        userKey = userKey.length() < 16 ? HumusonEncryptor.generateKey(userKey) : userKey.substring(0, 16);
        try {
            byte[] enc2 = null;
            if (useZip) {
                byte[] enc1 = HumusonZip.zipStringToBytes(str, charSet);
                enc2 = Seed.seedEncrypt(enc1, userKey.getBytes());
            } else {
                enc2 = Seed.seedEncrypt(str.getBytes(), userKey.getBytes());
            }
            returnStr = new String(Base64.encode((byte[])enc2), charSet);
        }
        catch (Exception e) {
            try {
                logger.error("encrypt error params[str:{}, userKey:{}, useZip:{}]", new Object[]{str, userKey, useZip, e});
            }
            catch (Throwable throwable) {
                if (logger.isDebugEnabled()) {
                    logger.debug("encrypt :{} params[str:{}, userKey:{}, useZip:{}]", new Object[]{returnStr, str, userKey, useZip});
                }
                throw throwable;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("encrypt :{} params[str:{}, userKey:{}, useZip:{}]", new Object[]{returnStr, str, userKey, useZip});
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("encrypt :{} params[str:{}, userKey:{}, useZip:{}]", new Object[]{returnStr, str, userKey, useZip});
        }
        return returnStr;
    }

    public static void main(String[] args) {
        HumusonEncryptor humusonEncryptor = new HumusonEncryptor();
        String pmsIdEncKey = "humuson0722^^_^^";
        String phone = "12341234";
        String encStr = HumusonEncryptor.encrypt(phone, pmsIdEncKey);
        System.out.println(encStr);
    }
}

