/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.writer;

import com.humuson.tms.mq.model.MgsPush;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.jms.JmsItemWriter;

public class TestWriter
extends JmsItemWriter<MgsPush.Request>
implements StepExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(TestWriter.class);

    public void beforeStep(StepExecution stepExecution) {
    }

    public void write(List<? extends MgsPush.Request> items) throws Exception {
        for (MgsPush.Request request : items) {
            for (MgsPush.PushPayload payload : request.getPayloadList()) {
                log.info("apns msg id : {}", (Object)payload.getApnsMessage().getMsgId());
                log.info("gcm msg id : {}", (Object)payload.getGcmMessage().getMsgId());
            }
        }
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return ExitStatus.COMPLETED;
    }
}

