/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.writer;

import com.humuson.tms.batch.domain.BaseResult;
import com.humuson.tms.batch.domain.ChannelSendType;
import com.humuson.tms.batch.domain.SmsResultLog;
import com.humuson.tms.batch.writer.AbstractResultWriter;
import com.humuson.tms.constrants.ChannelType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;

public class SmsResultWriter
extends AbstractResultWriter<SmsResultLog> {
    private static final Logger log = LoggerFactory.getLogger(SmsResultWriter.class);

    @Override
    public void execute(ChannelSendType channelSendType, String postId, String rtnType, List<SmsResultLog> logList) {
        log.info("execute [channelSendType:{}, postId:{}, size:{}", new Object[]{channelSendType, postId, logList.size()});
        SqlParameterSource[] params = SqlParameterSourceUtils.createBatch((Object[])logList.toArray());
        HashMap<String, HashMap<String, Integer>> scheduleStatMap = new HashMap<String, HashMap<String, Integer>>();
        String updateSendList = null;
        String updateScheduleStat = null;
        String listTable = logList.get(0).getListTable();
        HashMap<String, Integer> map = null;
        for (SmsResultLog smsResultLog : logList) {
            map = (HashMap<String, Integer>)scheduleStatMap.get(smsResultLog.getMonthDay() + smsResultLog.getHour());
            if (map == null) {
                map = new HashMap<String, Integer>();
                if (channelSendType.equals((Object)ChannelSendType.AUTO)) {
                    map.put("workday", (Integer)((Object)postId.split("_")[0]));
                    map.put("seqnNo", (Integer)((Object)postId.split("_")[0]));
                } else {
                    map.put("postId", (Integer)((Object)postId));
                }
                map.put("failCnt", 0);
                map.put("pushedCnt", 0);
                map.put("monthDay", (Integer)((Object)smsResultLog.getMonthDay()));
                map.put("hour", (Integer)((Object)smsResultLog.getHour()));
            }
            map.put("failCnt", (Integer)map.get("failCnt") + smsResultLog.getFailCnt());
            map.put("pushedCnt", (Integer)map.get("pushedCnt") + smsResultLog.getPushedCnt());
            scheduleStatMap.put(smsResultLog.getMonthDay() + smsResultLog.getHour(), map);
        }
        if (channelSendType.equals((Object)ChannelSendType.AUTO)) {
            updateSendList = this.updateAutoSendList.replace("@LIST_TABLE@", listTable);
            updateScheduleStat = this.updateAutoScheduleStat;
        } else if (channelSendType.equals((Object)ChannelSendType.CAMP)) {
            updateSendList = this.updateCampSendList.replace("@LIST_TABLE@", listTable);
            updateScheduleStat = this.updateCampScheduleStat;
        }
        Set statKeys = scheduleStatMap.keySet();
        try {
            log.info("update Send List [table:{}, count:{}]", (Object)listTable, (Object)params.length);
            this.updateResultServiceImpl.updateList(ChannelType.PUSH, channelSendType, rtnType, updateSendList, params);
            for (String key : statKeys) {
                log.info("update stat [SQL:{}, SendType:{}, RtnType:{}, {}]", new Object[]{updateScheduleStat, channelSendType.getCode(), rtnType, ((Map)scheduleStatMap.get(key)).toString()});
                this.namedParameterJdbcTemplate.update(updateScheduleStat, (Map)scheduleStatMap.get(key));
            }
        }
        catch (Exception exception) {
            for (SmsResultLog resultLog : logList) {
                try {
                    int cnt = this.namedParameterJdbcTemplate.update(updateSendList, resultLog.toMap());
                    if (cnt <= 0) continue;
                    this.namedParameterJdbcTemplate.update(updateScheduleStat, resultLog.toMap());
                }
                catch (Exception e2) {
                    log.error("update error [{}]", (Object)resultLog.toString());
                }
            }
        }
    }

    @Override
    protected void updateCheckFlag(List<? extends SmsResultLog> rawData) {
        long startTime = System.currentTimeMillis();
        BaseResult[] params = rawData.toArray(new SmsResultLog[rawData.size()]);
        try {
            this.updateResultServiceImpl.updateCheckFlag(this.updateCheckFlag, params);
        }
        catch (Exception e) {
            for (BaseResult param : params) {
                try {
                    this.updateResultServiceImpl.updateCheckFlag(this.updateCheckFlag, param);
                }
                catch (Exception e2) {
                    log.error("update error param:[{}]", (Object)param.toString(), (Object)e2);
                }
            }
        }
        log.info("update checkFlag [count:{}, elapseTime:{}]", (Object)rawData.size(), (Object)(System.currentTimeMillis() - startTime));
    }
}

