/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.writer;

import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.domain.PushQueue;
import com.humuson.tms.batch.domain.PushResult;
import com.humuson.tms.batch.service.AppUserRemover;
import com.humuson.tms.batch.service.PushInfoService;
import com.humuson.tms.batch.service.PushResultService;
import com.humuson.tms.batch.service.PushSendService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.launch.JobExecutionNotRunningException;
import org.springframework.batch.core.launch.NoSuchJobExecutionException;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;

public class PushSendWriter
implements ItemWriter<PushQueue>,
StepExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(PushSendWriter.class);
    private static final String MASS = "MASS";
    @Autowired
    protected PushInfoService<App, PushMessage> pushInfoService;
    @Autowired
    protected JdbcTemplate jdbcTemplate;
    @Autowired
    protected PushSendService<List<PushQueue>, List<PushResult>> mgsPushSendServiceImpl;
    @Autowired
    protected AppUserRemover appUserRemover;
    @Autowired
    protected PushResultService pushResultService;
    protected String appGrpKey;
    private String insertInAppMsg;
    protected int appGrpId;
    protected App appInfo;
    @Value(value="#{config['use.resend.gcm.for.private.failed']}")
    private boolean useResendGcm;
    @Value(value="#{config['tms.private.inactive.publish']}")
    private boolean privateInactivePublish;
    @Value(value="#{config['use.wakeup.gcm']}")
    private boolean useWakeupGcm;
    @Value(value="#{config['not.registed.android.immediately.update']}")
    private boolean immediatelyUpdate;
    @Value(value="#{config['use.mgs.public.push']}")
    protected boolean useMgsPublicPush;

    public void write(List<? extends PushQueue> rawData) throws Exception {
        if (this.isSendStop()) {
            log.info("PushSendWriter Stop!!");
        }
        long startTime = System.currentTimeMillis();
        if (this.useMgsPublicPush) {
            List<PushQueue> rawData2 = rawData;
            this.pushResultService.batchUpdateSendingStatus(rawData2);
            log.info("batch push que update");
        }
        ArrayList<Object[]> inAppMsgParams = new ArrayList<Object[]>();
        HashMap<String, List<PushQueue>> msgUidMap = new HashMap<String, List<PushQueue>>();
        for (PushQueue pushQue : rawData) {
            ArrayList<PushQueue> pushQueList = (ArrayList<PushQueue>)msgUidMap.get(pushQue.getPushMessage().getMsgUid());
            if (pushQueList == null || pushQueList.isEmpty()) {
                pushQueList = new ArrayList<PushQueue>();
            }
            pushQueList.add(pushQue);
            msgUidMap.put(pushQue.getPushMessage().getMsgUid(), pushQueList);
            inAppMsgParams.add(new Object[]{pushQue.getPushMessage().getExpireDate(), pushQue.getAppGrpId(), pushQue.getDeviceId(), MASS.equals(pushQue.getCustId()) ? "" : pushQue.getCustId(), pushQue.getReqUid(), pushQue.getPushMessage().getMsgUid(), pushQue.getPushType(), pushQue.getPushMessage().getPushTitle(), pushQue.getPushMessage().getPushMsg(), pushQue.getPushMessage().getPushValue(), pushQue.getPushMessage().getPushKey(), pushQue.getPushMessage().getMsgType(), pushQue.getPushMessage().getInAppContent(), pushQue.getPushMessage().getPushImg(), pushQue.getPushMessage().getEtc1(), pushQue.getPushMessage().getEtc2(), pushQue.getPushMessage().getEtc3(), pushQue.getPushMessage().getEtc4(), pushQue.getPushMessage().getEtc5(), pushQue.getPushMessage().getEtc6()});
        }
        List<Object> resList = null;
        try {
            this.insertInAppMsg(inAppMsgParams);
            log.info("insertUserMsg End [count:{}, elapseTime:{}]", (Object)inAppMsgParams.size(), (Object)(System.currentTimeMillis() - startTime));
            startTime = System.currentTimeMillis();
            resList = this.sendRequest(msgUidMap);
            log.info("push send End [count:{}, elapseTime:{}]", (Object)resList.size(), (Object)(System.currentTimeMillis() - startTime));
        }
        catch (Exception e) {
            log.error("Push Send Error ", (Throwable)e);
            if (resList == null) {
                resList = new ArrayList();
                StringBuilder sb = new StringBuilder();
                for (PushQueue pushQueue : rawData) {
                    sb.setLength(0);
                    sb.append(pushQueue.getPushId()).append("&&").append(pushQueue.getDeviceId()).append("&&").append(pushQueue.getReqUid()).append("&&").append(pushQueue.getCustId()).toString();
                    resList.add(new PushResult(this.appGrpId, "4000", sb.toString(), "U", pushQueue.getRowId()));
                }
            }
            throw e;
        }
        finally {
            startTime = System.currentTimeMillis();
            this.pushResultService.batchUpdatePushResult(resList);
            log.info("update push result End [count:{}, elapseTime:{}]", (Object)resList.size(), (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private List<PushResult> sendRequest(Map<String, List<PushQueue>> msgUidMap) {
        ArrayList<PushResult> resList = new ArrayList<PushResult>();
        Set<String> msgUidSet = msgUidMap.keySet();
        List<Object> tmpResult = new ArrayList();
        ArrayList oneToOneList = new ArrayList();
        for (String msgUid : msgUidSet) {
            if (msgUidMap.get(msgUid).size() == 1) {
                oneToOneList.addAll(msgUidMap.get(msgUid));
                continue;
            }
            List<PushQueue> msgUidQueList = msgUidMap.get(msgUid);
            try {
                tmpResult = this.mgsPushSendServiceImpl.request(msgUidQueList, msgUidQueList.get(0).getPushMessage(), this.useResendGcm, this.privateInactivePublish, this.useWakeupGcm);
                log.info("push send result : {} , msgUid :{}", (Object)tmpResult.size(), (Object)msgUid);
            }
            catch (Exception e) {
                log.error("Push Request failed", (Throwable)e);
                tmpResult.clear();
                StringBuilder sb = new StringBuilder();
                for (PushQueue pushQueue : msgUidQueList) {
                    sb.setLength(0);
                    sb.append(pushQueue.getPushId()).append("&&").append(pushQueue.getDeviceId()).append("&&").append(pushQueue.getReqUid()).append("&&").append(pushQueue.getCustId()).toString();
                    tmpResult.add(new PushResult(this.appGrpId, "4000", sb.toString(), this.appInfo.getAppOsMap().get(pushQueue.getAppId()), pushQueue.getRowId()));
                }
            }
            resList.addAll(tmpResult);
        }
        if (!oneToOneList.isEmpty()) {
            log.info("oneToOneList size: {}", (Object)oneToOneList.size());
            tmpResult = this.mgsPushSendServiceImpl.request(oneToOneList, this.useResendGcm, this.privateInactivePublish, this.useWakeupGcm);
            resList.addAll(tmpResult);
        }
        return resList;
    }

    protected boolean isSendStop() throws NoSuchJobExecutionException, JobExecutionNotRunningException {
        return false;
    }

    protected void insertInAppMsg(List<Object[]> inAppMsgParams) {
        if (!inAppMsgParams.isEmpty()) {
            try {
                this.jdbcTemplate.batchUpdate(this.insertInAppMsg, inAppMsgParams);
            }
            catch (Exception e) {
                log.error("insert inAppMsg error", (Throwable)e);
            }
        }
    }

    public void beforeStep(StepExecution stepExecution) {
        this.appGrpKey = stepExecution.getJobExecution().getJobParameters().getString("app.grp.key");
        this.appGrpId = (int)stepExecution.getJobExecution().getExecutionContext().getLong("app.grp.id");
        this.appInfo = this.pushInfoService.getAppInfo(this.appGrpKey);
        this.mgsPushSendServiceImpl.init(this.appInfo);
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        this.mgsPushSendServiceImpl.close();
        return null;
    }

    public void setAppGrpKey(String appGrpKey) {
        this.appGrpKey = appGrpKey;
    }

    public void setInsertInAppMsg(String insertInAppMsg) {
        this.insertInAppMsg = insertInAppMsg;
    }
}

