/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.writer;

import com.humuson.tms.batch.domain.BaseResult;
import com.humuson.tms.batch.domain.ChannelSendType;
import com.humuson.tms.batch.domain.PushResultLog;
import com.humuson.tms.batch.writer.AbstractResultWriter;
import com.humuson.tms.constrants.ChannelType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;

public class PushResultWriter
extends AbstractResultWriter<PushResultLog> {
    private static final Logger log = LoggerFactory.getLogger(PushResultWriter.class);
    @Value(value="#{dbConfig['tms.jdbc.type']}")
    protected String dbType;

    @Override
    public void execute(ChannelSendType channelSendType, String postId, String rtnType, List<PushResultLog> logList) {
        block52: {
            SqlParameterSource[] pkParams;
            SqlParameterSource[] params;
            Set statKeys;
            String updateClickLinkStat;
            String updateResponseStat;
            String updateScheduleStat;
            String updateResponseList;
            boolean isResponseSendListUpdateSuccess;
            List<Object> pkLogList;
            ArrayList remainResponseStatList;
            HashMap<String, HashMap<String, Integer>> scheduleStatMap;
            block51: {
                log.info("execute [channelSendType:{}, postId:{}, rtnType:{}, size:{}", new Object[]{channelSendType, postId, rtnType, logList.size()});
                scheduleStatMap = new HashMap<String, HashMap<String, Integer>>();
                ArrayList remainStatList = new ArrayList();
                remainResponseStatList = new ArrayList();
                pkLogList = new ArrayList();
                boolean isSendListUpdateSuccess = false;
                boolean isPkSendListUpdateSuccess = false;
                isResponseSendListUpdateSuccess = false;
                String updateSendList = null;
                updateResponseList = null;
                updateScheduleStat = null;
                updateResponseStat = null;
                updateClickLinkStat = null;
                String listTable = logList.get(0).getListTable();
                boolean isOracleDb = "ORACLE".equalsIgnoreCase(this.dbType);
                boolean isRowIdUpdate = false;
                if (!isOracleDb) {
                    pkLogList = logList;
                } else if ("R".equals(rtnType) || "C".equals(rtnType)) {
                    pkLogList = logList;
                }
                Iterator<PushResultLog> itr = logList.iterator();
                while (itr.hasNext()) {
                    PushResultLog resultLog = itr.next();
                    HashMap<String, Integer> map = (HashMap<String, Integer>)scheduleStatMap.get(resultLog.getMonthDay() + resultLog.getHour());
                    if (map == null) {
                        map = new HashMap<String, Integer>();
                        if (channelSendType.equals((Object)ChannelSendType.AUTO)) {
                            map.put("workday", (Integer)((Object)postId.split("_")[0]));
                            map.put("seqNo", (Integer)((Object)postId.split("_")[1]));
                        } else {
                            map.put("postId", (Integer)((Object)postId));
                        }
                        map.put("failCnt", 0);
                        map.put("pushedCnt", 0);
                        map.put("clickCnt", 0);
                        map.put("clickCntAndroid", 0);
                        map.put("clickCntIos", 0);
                        map.put("openCnt", 0);
                        map.put("openCntAndroid", 0);
                        map.put("openCntIos", 0);
                        map.put("monthDay", (Integer)((Object)resultLog.getMonthDay()));
                        map.put("hour", (Integer)((Object)resultLog.getHour()));
                    }
                    map.put("failCnt", (Integer)map.get("failCnt") + resultLog.getFailCnt());
                    map.put("pushedCnt", (Integer)map.get("pushedCnt") + resultLog.getPushedCnt());
                    map.put("clickCnt", (Integer)map.get("clickCnt") + resultLog.getClickCnt());
                    map.put("clickCntAndroid", (Integer)map.get("clickCntAndroid") + resultLog.getClickCntAndroid());
                    map.put("clickCntIos", (Integer)map.get("clickCntIos") + resultLog.getClickCntIos());
                    map.put("openCnt", (Integer)map.get("openCnt") + resultLog.getOpenCnt());
                    map.put("openCntAndroid", (Integer)map.get("openCntAndroid") + resultLog.getOpenCntAndroid());
                    map.put("openCntIos", (Integer)map.get("openCntIos") + resultLog.getOpenCntIos());
                    if (isOracleDb && ("S".equals(rtnType) || "D".equals(rtnType)) && (resultLog.getRowId() == null || "".equals(resultLog.getRowId()))) {
                        pkLogList.add(resultLog);
                        itr.remove();
                    }
                    scheduleStatMap.put(resultLog.getMonthDay() + resultLog.getHour(), map);
                }
                updateSendList = this.makeListQuery(rtnType, channelSendType, listTable, isOracleDb);
                if (!"D".equals(rtnType)) {
                    updateScheduleStat = this.makeSchdQuery(channelSendType);
                }
                statKeys = scheduleStatMap.keySet();
                remainStatList.addAll(statKeys);
                remainResponseStatList.addAll(statKeys);
                params = null;
                if (isOracleDb && ("S".equals(rtnType) || "D".equals(rtnType))) {
                    params = SqlParameterSourceUtils.createBatch((Object[])logList.toArray());
                }
                pkParams = SqlParameterSourceUtils.createBatch((Object[])pkLogList.toArray());
                try {
                    if (log.isDebugEnabled()) {
                        log.info("update Send List [table:{}, count:{}, SQL: {}]", new Object[]{listTable, (params != null ? params.length : 0) + (pkParams != null ? pkParams.length : 0), updateSendList});
                    }
                    if (params != null && (params != null ? params.length : 0) >= 1) {
                        isRowIdUpdate = true;
                        this.updateResultServiceImpl.updateList(ChannelType.PUSH, channelSendType, rtnType, updateSendList, params);
                    }
                    isSendListUpdateSuccess = true;
                    if (pkParams != null && pkParams.length >= 1) {
                        this.updateResultServiceImpl.updateList(ChannelType.PUSH, channelSendType, rtnType, updateSendList, pkParams);
                    }
                    isPkSendListUpdateSuccess = true;
                    log.info("update send list count :{}", (Object)((params != null ? params.length : 0) + (pkParams != null ? pkParams.length : 0)));
                    if ("D".equals(rtnType)) break block51;
                    int cnt = 0;
                    for (String string : statKeys) {
                        if (log.isDebugEnabled()) {
                            log.info("update stat [SQL:{}, SendType:{}, RtnType:{}, {}]", new Object[]{updateScheduleStat, channelSendType.getCode(), rtnType, ((Map)scheduleStatMap.get(string)).toString()});
                        }
                        cnt += this.updateResultServiceImpl.updateStat(updateScheduleStat, (Map)scheduleStatMap.get(string));
                        remainStatList.remove(string);
                    }
                    log.info("update scheduleStat count:{}", (Object)cnt);
                }
                catch (Exception e) {
                    int cnt;
                    log.error("push que log update error / retry push que log update :{} ", (Throwable)e);
                    log.error("push que log update error / remain stat list ( null is something wrong ) :{} ", remainStatList);
                    if (!isSendListUpdateSuccess && isOracleDb && ("S".equals(rtnType) || "D".equals(rtnType)) && isRowIdUpdate) {
                        for (PushResultLog pushResultLog : logList) {
                            try {
                                cnt = this.namedParameterJdbcTemplate.update(updateSendList, pushResultLog.toMap());
                                if (cnt >= 1) continue;
                                log.error("update is null error( uptCnt = 0 ) : [{}]", (Object)pushResultLog.toString());
                            }
                            catch (Exception e2) {
                                log.error("update error [{}], msg:{}", (Object)pushResultLog.toString(), (Object)e2.getMessage());
                            }
                        }
                    }
                    if (!isPkSendListUpdateSuccess) {
                        for (PushResultLog pushResultLog : pkLogList) {
                            try {
                                cnt = this.namedParameterJdbcTemplate.update(updateSendList, pushResultLog.toMap());
                                if (cnt >= 1) continue;
                                log.error("update is null error( uptCnt = 0 ) : [{}]", (Object)pushResultLog.toString());
                            }
                            catch (Exception e2) {
                                log.error("update error [{}], msg:{}", (Object)pushResultLog.toString(), (Object)e2.getMessage());
                            }
                        }
                    }
                    if ("D".equals(rtnType)) break block51;
                    for (String string : scheduleStatMap.keySet()) {
                        try {
                            if (!remainStatList.contains(string)) continue;
                            this.updateResultServiceImpl.updateStat(updateScheduleStat, (Map)scheduleStatMap.get(string));
                            log.info("reyty update stat success Key : [{}], Value: {} msg:{}", (Object)string, scheduleStatMap.get(string));
                        }
                        catch (Exception e1) {
                            log.error("reyty update stat error  FailKey : [{}], FailValue: {} msg:{}", new Object[]{string, scheduleStatMap.get(string), e1.getMessage()});
                        }
                    }
                }
            }
            if ("R".equals(rtnType) || "C".equals(rtnType)) {
                if ("R".equals(rtnType)) {
                    if (channelSendType.equals((Object)ChannelSendType.AUTO)) {
                        updateResponseList = this.updateAutoOpenList;
                        updateResponseStat = this.updateAutoOpenStat;
                    } else if (channelSendType.equals((Object)ChannelSendType.CAMP)) {
                        updateResponseList = this.updateCampOpenList;
                        updateResponseStat = this.updateCampOpenStat;
                    }
                } else if ("C".equals(rtnType)) {
                    if (channelSendType.equals((Object)ChannelSendType.AUTO)) {
                        updateResponseList = this.updateAutoClickList;
                        updateResponseStat = this.updateAutoClickStat;
                        updateClickLinkStat = this.updateAutoClickLinkStat;
                    } else if (channelSendType.equals((Object)ChannelSendType.CAMP)) {
                        updateResponseList = this.updateCampClickList;
                        updateResponseStat = this.updateCampClickStat;
                        updateClickLinkStat = this.updateCampClickLinkStat;
                    }
                }
                log.info("update Response List [table:{}, count:{}]", (Object)("R".equals(rtnType) ? "Open" : "Click"), (Object)pkParams.length);
                try {
                    this.updateResultServiceImpl.updateList(ChannelType.PUSH, channelSendType, rtnType, updateResponseList, pkParams);
                    isResponseSendListUpdateSuccess = true;
                    for (Object key : statKeys) {
                        log.info("update stat [SendType:{}, RtnType:{}, {}]", new Object[]{channelSendType.getCode(), rtnType, ((Map)scheduleStatMap.get(key)).toString()});
                        this.updateResultServiceImpl.updateStat(updateResponseStat, (Map)scheduleStatMap.get(key));
                        remainResponseStatList.remove(key);
                    }
                    if (updateClickLinkStat != null) {
                        this.updateResultServiceImpl.updateResponseStat(updateClickLinkStat, pkParams);
                    }
                }
                catch (Exception e) {
                    log.error("update Response error : {} ", (Throwable)e);
                    if (!isResponseSendListUpdateSuccess) {
                        for (PushResultLog pushResultLog : pkLogList) {
                            try {
                                this.namedParameterJdbcTemplate.update(updateResponseList, (SqlParameterSource)new BeanPropertySqlParameterSource((Object)pushResultLog));
                            }
                            catch (Exception exception) {
                                log.error("reyty update Response error [{}]", (Object)pushResultLog.toString(), (Object)exception);
                            }
                        }
                    }
                    for (String string : scheduleStatMap.keySet()) {
                        try {
                            if (!remainResponseStatList.contains(string)) continue;
                            this.updateResultServiceImpl.updateStat(updateScheduleStat, (Map)scheduleStatMap.get(string));
                            log.info("retry update response stat success Key : [{}],  msg:{}", (Object)string, scheduleStatMap.get(string));
                        }
                        catch (Exception exception) {
                            log.error("retry update response stat error  FailKey : [{}],  msg:{}", new Object[]{string, scheduleStatMap.get(string), exception.getMessage()});
                        }
                    }
                    if (updateClickLinkStat == null) break block52;
                    try {
                        this.updateResultServiceImpl.updateResponseStat(updateClickLinkStat, params);
                    }
                    catch (Exception e2) {
                        log.error("retry updateClickLinkStat error msg:{}", (Object)e2.getMessage());
                    }
                }
            }
        }
    }

    @Override
    protected void updateCheckFlag(List<? extends PushResultLog> rawData) {
        long startTime = System.currentTimeMillis();
        BaseResult[] params = rawData.toArray(new PushResultLog[rawData.size()]);
        try {
            this.updateResultServiceImpl.updateCheckFlag(this.updateCheckFlag, params);
        }
        catch (Exception e) {
            for (BaseResult param : params) {
                try {
                    this.updateResultServiceImpl.updateCheckFlag(this.updateCheckFlag, param);
                }
                catch (Exception e2) {
                    log.error("update error param:[{}]", (Object)param.toString(), (Object)e2);
                }
            }
        }
        log.info("update checkFlag [count:{}, elapseTime:{}]", (Object)rawData.size(), (Object)(System.currentTimeMillis() - startTime));
    }

    private String makeListQuery(String rtnType, ChannelSendType channelSendType, String listTable, boolean isOracleDb) {
        String query = null;
        if (isOracleDb && "S".equals(rtnType)) {
            if (channelSendType.equals((Object)ChannelSendType.AUTO)) {
                query = this.updateAutoSendListByRowId.replace("@LIST_TABLE@", listTable);
            } else if (channelSendType.equals((Object)ChannelSendType.CAMP)) {
                query = this.updateCampSendListByRowId.replace("@LIST_TABLE@", listTable);
            }
        } else if (isOracleDb && "D".equals(rtnType)) {
            if (channelSendType.equals((Object)ChannelSendType.AUTO)) {
                query = this.updateAutoSendListDeliverByRowId.replace("@LIST_TABLE@", listTable);
            } else if (channelSendType.equals((Object)ChannelSendType.CAMP)) {
                query = this.updateCampSendListDeliverByRowId.replace("@LIST_TABLE@", listTable);
            }
        } else if ("D".equals(rtnType)) {
            if (channelSendType.equals((Object)ChannelSendType.AUTO)) {
                query = this.updateAutoSendListDeliver.replace("@LIST_TABLE@", listTable);
            } else if (channelSendType.equals((Object)ChannelSendType.CAMP)) {
                query = this.updateCampSendListDeliver.replace("@LIST_TABLE@", listTable);
                query = query.replace("@PK_HINT@", listTable.replace("TMS", "PK"));
            }
        } else if (channelSendType.equals((Object)ChannelSendType.AUTO)) {
            query = this.updateAutoSendList.replace("@LIST_TABLE@", listTable);
        } else if (channelSendType.equals((Object)ChannelSendType.CAMP)) {
            query = this.updateCampSendList.replace("@LIST_TABLE@", listTable);
            query = query.replace("@PK_HINT@", listTable.replace("TMS", "PK"));
        }
        return query;
    }

    private String makeSchdQuery(ChannelSendType channelSendType) {
        String query = null;
        if (channelSendType.equals((Object)ChannelSendType.AUTO)) {
            query = this.updateAutoScheduleStat;
        } else if (channelSendType.equals((Object)ChannelSendType.CAMP)) {
            query = this.updateCampScheduleStat;
        }
        return query;
    }
}

