/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.writer;

import com.google.android.gcm.ccs.server.CcsConnectionManager;
import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.domain.PushQueue;
import com.humuson.tms.batch.domain.PushResult;
import com.humuson.tms.batch.service.AppUserRemover;
import com.humuson.tms.batch.service.GcmHttpService;
import com.humuson.tms.batch.service.PushInfoService;
import com.humuson.tms.batch.service.PushResultService;
import com.humuson.tms.batch.service.PushSendService;
import com.humuson.tms.batch.service.impl.GcmCcsService;
import com.humuson.tms.constrants.StatusType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

public class PushReSendWriter
implements ItemWriter<PushQueue>,
StepExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(PushReSendWriter.class);
    @Autowired
    protected PushInfoService<App, PushMessage> pushInfoService;
    @Autowired
    protected PushSendService<List<PushQueue>, List<PushResult>> mgsPushSendServiceImpl;
    @Autowired
    protected PushResultService pushResultService;
    @Autowired
    protected AppUserRemover appUserRemover;
    protected String appGrpKey;
    protected App appInfo;
    @Value(value="#{config['use.resend.gcm.for.private.failed']}")
    private boolean useResendGcm;
    @Value(value="#{config['not.registed.android.immediately.update']}")
    private boolean immediatelyUpdate;
    @Value(value="#{config['send.gcm.type']}")
    private String gcmType;
    @Autowired
    GcmCcsService gcmCcsService;
    @Autowired
    @Qualifier(value="gcmHttpServiceImpl")
    GcmHttpService<PushResult, PushQueue> gcmHttpServiceImpl;
    @Autowired
    CcsConnectionManager ccsConnectionManager;

    public void write(List<? extends PushQueue> rawData) throws Exception {
        long startTime = System.currentTimeMillis();
        HashMap<String, List<PushQueue>> reSendGcmMsgUidMap = new HashMap<String, List<PushQueue>>();
        ArrayList<PushQueue> removePushQueList = new ArrayList<PushQueue>();
        for (PushQueue pushQueue : rawData) {
            if ("I".equals(pushQueue.getAppOs())) {
                pushQueue.setSendStatus(StatusType.ERROR.getCode());
                pushQueue.setErrorCode("7500");
                removePushQueList.add(pushQueue);
                continue;
            }
            if (this.useResendGcm) {
                ArrayList<PushQueue> pushQueList = (ArrayList<PushQueue>)reSendGcmMsgUidMap.get(pushQueue.getPushMessage().getMsgUid());
                if (pushQueList == null) {
                    pushQueList = new ArrayList<PushQueue>();
                }
                pushQueList.add(pushQueue);
                reSendGcmMsgUidMap.put(pushQueue.getPushMessage().getMsgUid(), pushQueList);
                continue;
            }
            pushQueue.setSendStatus(StatusType.ERROR.getCode());
            pushQueue.setErrorCode("7500");
            removePushQueList.add(pushQueue);
        }
        if (!removePushQueList.isEmpty()) {
            this.pushResultService.batchUpdatePushQueue(removePushQueList);
        }
        this.resendGcm(startTime, reSendGcmMsgUidMap);
    }

    private void resendGcm(long startTime, Map<String, List<PushQueue>> reSendGcmMsgUidMap) {
        ArrayList<PushResult> resList = new ArrayList<PushResult>();
        if (this.useResendGcm && !reSendGcmMsgUidMap.keySet().isEmpty()) {
            Set<String> keySet = reSendGcmMsgUidMap.keySet();
            for (String key : keySet) {
                List<PushQueue> pushQueList = reSendGcmMsgUidMap.get(key);
                if ("http".equalsIgnoreCase(this.gcmType)) {
                    if (pushQueList.size() == 1) {
                        resList.add(this.gcmHttpServiceImpl.sendGcmMessage(pushQueList.get(0), this.appInfo.getGcmApiKey()));
                        continue;
                    }
                    resList.addAll(this.gcmHttpServiceImpl.sendGcmOne2OneList(pushQueList, this.appInfo.getGcmApiKey()));
                    continue;
                }
                if (!"xmpp".equalsIgnoreCase(this.gcmType)) continue;
                StringBuilder sb = new StringBuilder();
                for (PushQueue que : pushQueList) {
                    sb.setLength(0);
                    String id = sb.append(que.getPushId()).append("&&").append(que.getDeviceId()).append("&&").append(que.getReqUid()).append("&&").append(que.getCustId()).toString();
                    String ccsMessage = this.gcmCcsService.makeCcsMessage(que, que.getPushMessage(), this.appInfo.getAppGrpId());
                    try {
                        this.gcmCcsService.sendDownstreamMessage(ccsMessage);
                    }
                    catch (Exception e) {
                        log.error("exception in resendGcm (XMPP) : {}", (Object)que.getPushId(), (Object)e);
                        resList.add(new PushResult(this.appInfo.getAppGrpId(), "2009", sb.toString(), "A", que.getRowId()));
                        this.gcmCcsService.setHitCount(0);
                        this.gcmCcsService.reset();
                        continue;
                    }
                    resList.add(new PushResult(this.appInfo.getAppGrpId(), "3002", sb.toString(), "A", que.getRowId()));
                }
            }
        }
        if (!resList.isEmpty()) {
            try {
                this.pushResultService.batchUpdatePushResult(resList);
            }
            catch (Exception e) {
                log.error("update push result ", (Throwable)e);
                for (PushResult result : resList) {
                    try {
                        this.pushResultService.updatePushResult(result);
                    }
                    catch (Exception e2) {
                        log.error("push result update error {}, [{}]", (Object)e2, (Object)result.toString());
                    }
                }
            }
            log.info("push ReSend End [count:{}, elapseTime:{}]", (Object)resList.size(), (Object)(System.currentTimeMillis() - startTime));
        }
    }

    public void beforeStep(StepExecution stepExecution) {
        this.appGrpKey = stepExecution.getJobExecution().getJobParameters().getString("app.grp.key");
        this.appInfo = this.pushInfoService.getAppInfo(this.appGrpKey);
        this.gcmHttpServiceImpl.init(this.appInfo);
        this.gcmCcsService.init(this.appInfo.getGcmProjectNum(), this.appInfo.getGcmApiKey());
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return stepExecution.getExitStatus();
    }

    public void setAppGrpKey(String appGrpKey) {
        this.appGrpKey = appGrpKey;
    }
}

