/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.writer;

import com.humuson.tms.batch.domain.TargetSchedule;
import com.humuson.tms.batch.job.partition.KeyDivider;
import com.humuson.tms.batch.service.PostIdDevideService;
import com.humuson.tms.batch.service.ScheduleService;
import com.humuson.tms.batch.service.SendListService;
import com.humuson.tms.batch.service.TargetServerService;
import com.humuson.tms.common.model.target.TargetData;
import com.humuson.tms.constrants.TargetStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;

public class JdbcTargetRawDataWriter
implements ItemWriter<TargetData>,
StepExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(JdbcTargetRawDataWriter.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    @Autowired
    PostIdDevideService postIdDevideService;
    @Autowired
    TargetServerService targetServerService;
    @Autowired
    SendListService sendListServiceImpl;
    @Autowired
    ScheduleService<TargetSchedule> targetScheduleService;
    @Autowired
    JobOperator jobOperator;
    private String updateScheduleInfo;
    private String updateDeduplicationInfo;
    private String insertSiteUser;
    private String insertTempSendList;
    private String updateStatusStopInfo;
    private String deleteTempSendListWriter;
    private String insertTargetErrorList;
    private String postId;
    private String msgId;
    private String addSiteUserYn;
    private String deduplicationYn;
    private List<Properties> targetServerList;
    private List<Properties> postIdList;
    private StepExecution stepExecution;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(List<? extends TargetData> rawData) throws Exception {
        block24: {
            int duplicateCount;
            block25: {
                int insertCount;
                int filterErrorCount;
                HashMap<String, Integer> serverIdTargetCntMap;
                long startTime;
                block22: {
                    block23: {
                        if (!this.targetScheduleService.isCanceled(this.msgId)) break block23;
                        log.info("stepExecution.getJobExecutionId() : {}", (Object)this.stepExecution.getJobExecutionId());
                        boolean isStoped = false;
                        try {
                            isStoped = this.jobOperator.stop(this.stepExecution.getJobExecutionId().longValue());
                            if (isStoped) {
                                this.targetScheduleService.updateScheduleStatus(this.msgId, TargetStatus.CANCEL_COMPLETE.getCode());
                                this.jdbcTemplate.update(this.deleteTempSendListWriter, new Object[]{this.msgId});
                            }
                            log.info("[JdbcTargetRawDataWriter] Target Stop Success ...");
                        }
                        catch (Exception e) {
                            log.error("[JdbcTargetRawDataWriter] updateScheduleStatus ERROR : " + e.getMessage());
                        }
                        break block24;
                    }
                    ArrayList<? extends TargetData> targetDataList = new ArrayList<TargetData>();
                    targetDataList.addAll(rawData);
                    duplicateCount = 0;
                    if ("Y".equals(this.deduplicationYn)) {
                        SqlParameterSource[] dupInsertParam = SqlParameterSourceUtils.createBatch((Object[])targetDataList.toArray());
                        try {
                            this.sendListServiceImpl.insertSendTempList(dupInsertParam);
                        }
                        catch (Exception e) {
                            log.error("[JdbcTargetRawDataWriter][Exception] : " + e.getMessage());
                            int size = targetDataList.size();
                            for (int i = size - 1; i >= 0; --i) {
                                SqlParameterSource param = dupInsertParam[i];
                                try {
                                    this.sendListServiceImpl.insertSendTempList(param);
                                    continue;
                                }
                                catch (Exception ee) {
                                    this.jdbcTemplate.update(this.insertTargetErrorList, new Object[]{param.getValue("channelType"), param.getValue("msgId"), param.getValue("seqNo"), param.getValue("memberId"), param.getValue("duplicateKey"), "DE"});
                                    targetDataList.remove(i);
                                    ++duplicateCount;
                                }
                            }
                        }
                    }
                    log.info("[JdbcTargetRawDataWriter] targetDataList.size : {} duplicateCount : {}", (Object)targetDataList.size(), (Object)duplicateCount);
                    if (targetDataList.isEmpty()) break block25;
                    startTime = System.currentTimeMillis();
                    int targetSize = targetDataList.size();
                    KeyDivider abTestPartitioner = new KeyDivider("POST_ID", "AB_TEST_RATE");
                    abTestPartitioner.divisionId(targetDataList.size(), this.postIdList);
                    KeyDivider serverIdPartitioner = new KeyDivider("SERVER_ID", "PARTICIPATION_RATE");
                    serverIdPartitioner.divisionId(targetDataList.size(), this.targetServerList);
                    log.info("targetDataList size :{}, serverIdPartitioner : {}", (Object)targetSize, (Object)serverIdPartitioner.toString());
                    serverIdTargetCntMap = new HashMap<String, Integer>();
                    String serverIdKey = null;
                    Integer serverIdTargetCnt = null;
                    filterErrorCount = 0;
                    ArrayList<TargetData> newTargetData = new ArrayList<TargetData>();
                    for (int i = 0; i < targetSize; ++i) {
                        TargetData targetData = (TargetData)targetDataList.get(i);
                        targetData.setPostId(abTestPartitioner.getId(i));
                        targetData.setServerId(serverIdPartitioner.getId(i));
                        serverIdKey = targetData.getPostId() + "_" + targetData.getServerId();
                        if (log.isDebugEnabled()) {
                            // empty if block
                        }
                        if ((serverIdTargetCnt = (Integer)serverIdTargetCntMap.get(serverIdKey)) == null) {
                            serverIdTargetCnt = 0;
                        }
                        newTargetData.add(targetData);
                        if (log.isDebugEnabled()) {
                            // empty if block
                        }
                        serverIdTargetCnt = serverIdTargetCnt + 1;
                        serverIdTargetCntMap.put(serverIdKey, serverIdTargetCnt);
                    }
                    log.info("newTargetData.size :{}", (Object)newTargetData.size());
                    insertCount = 0;
                    SqlParameterSource[] params = SqlParameterSourceUtils.createBatch((Object[])newTargetData.toArray());
                    try {
                        insertCount = this.sendListServiceImpl.insertSendList(params);
                        if (!"Y".equals(this.addSiteUserYn)) break block22;
                        this.namedParameterJdbcTemplate.batchUpdate(this.insertSiteUser, params);
                    }
                    catch (Exception e) {
                        try {
                            log.error("insert error", (Throwable)e);
                            int size = newTargetData.size();
                            for (int i = size - 1; i >= 0; --i) {
                                SqlParameterSource param = params[i];
                                try {
                                    insertCount += this.sendListServiceImpl.insertSendList(param);
                                    if (!"Y".equals(this.addSiteUserYn)) continue;
                                    this.namedParameterJdbcTemplate.update(this.insertSiteUser, param);
                                    continue;
                                }
                                catch (Exception e2) {
                                    log.error("duplicate skip [m_id:{}, m_name:{}, m_email:{}, m_phone:{}, deviceId:{}]", new Object[]{param.getValue("memberId"), param.getValue("memberName"), param.getValue("memberEmail"), param.getValue("memberPhone"), param.getValue("deviceId"), e2});
                                    this.jdbcTemplate.update(this.insertTargetErrorList, new Object[]{param.getValue("channelType"), param.getValue("msgId"), param.getValue("seqNo"), param.getValue("memberId"), param.getValue("channelType").equals("EM") ? param.getValue("memberEmail") : (param.getValue("channelType").equals("SM") ? param.getValue("memberPhone") : param.getValue("deviceId")), "OE"});
                                    ++filterErrorCount;
                                    serverIdKey = abTestPartitioner.getId(i + 1) + "_" + serverIdPartitioner.getId(i + 1);
                                    serverIdTargetCnt = (Integer)serverIdTargetCntMap.get(serverIdKey);
                                    serverIdTargetCnt = serverIdTargetCnt - 1;
                                    serverIdTargetCntMap.put(serverIdKey, serverIdTargetCnt);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            log.info("insert send list [size : {}, elapseTime:{}, duplicateCnt : {}]", new Object[]{insertCount, System.currentTimeMillis() - startTime, duplicateCount});
                            throw throwable;
                        }
                        log.info("insert send list [size : {}, elapseTime:{}, duplicateCnt : {}]", new Object[]{insertCount, System.currentTimeMillis() - startTime, duplicateCount});
                    }
                }
                log.info("insert send list [size : {}, elapseTime:{}, duplicateCnt : {}]", new Object[]{insertCount, System.currentTimeMillis() - startTime, duplicateCount});
                this.jdbcTemplate.update(this.updateScheduleInfo, new Object[]{insertCount, filterErrorCount, duplicateCount, this.msgId});
                Set serverIdByPostId = serverIdTargetCntMap.keySet();
                String[] keys = null;
                for (String key : serverIdByPostId) {
                    keys = key.split("_");
                    this.targetServerService.updateTargetServerInfo(keys[0], keys[1], (Integer)serverIdTargetCntMap.get(key));
                }
                break block24;
            }
            if (duplicateCount > 0) {
                this.jdbcTemplate.update(this.updateDeduplicationInfo, new Object[]{duplicateCount, this.msgId});
            }
        }
    }

    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        this.postId = stepExecution.getJobParameters().getString("post.id");
        this.msgId = stepExecution.getJobParameters().getString("msg.id");
        this.addSiteUserYn = stepExecution.getJobExecution().getExecutionContext().getString("add.site.user.yn", "N");
        this.deduplicationYn = stepExecution.getJobParameters().getString("deduplication.yn");
        this.targetServerList = this.targetServerService.getTargetServerList(this.postId);
        this.postIdList = this.postIdDevideService.getAbTestPostIds(this.msgId, this.postId);
        log.info("postIdList : {}, deduplicationYn : {} ", (Object)this.postIdList.toString(), (Object)this.deduplicationYn);
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return stepExecution.getExitStatus();
    }

    public static void main(String[] args) {
        String a = "lBME72nnpBRKBnzm/oph9+5eo8opEDDZIat9OtjK4l4=";
        System.out.println(a.length());
    }

    public void setUpdateScheduleInfo(String updateScheduleInfo) {
        this.updateScheduleInfo = updateScheduleInfo;
    }

    public void setUpdateDeduplicationInfo(String updateDeduplicationInfo) {
        this.updateDeduplicationInfo = updateDeduplicationInfo;
    }

    public void setInsertSiteUser(String insertSiteUser) {
        this.insertSiteUser = insertSiteUser;
    }

    public void setInsertTempSendList(String insertTempSendList) {
        this.insertTempSendList = insertTempSendList;
    }

    public void setUpdateStatusStopInfo(String updateStatusStopInfo) {
        this.updateStatusStopInfo = updateStatusStopInfo;
    }

    public void setDeleteTempSendListWriter(String deleteTempSendListWriter) {
        this.deleteTempSendListWriter = deleteTempSendListWriter;
    }

    public void setInsertTargetErrorList(String insertTargetErrorList) {
        this.insertTargetErrorList = insertTargetErrorList;
    }
}

