/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.writer;

import com.humuson.tms.batch.job.partition.KeyDivider;
import com.humuson.tms.batch.service.SendListService;
import com.humuson.tms.batch.service.TargetServerService;
import com.humuson.tms.common.model.target.TargetData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;

public class JdbcOtpmzTargetWriter
implements ItemWriter<TargetData>,
StepExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(JdbcOtpmzTargetWriter.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    TargetServerService targetServerService;
    @Autowired
    SendListService sendListServiceImpl;
    private String insertSendList;
    private String updateScheduleInfo;
    private String updateDeduplicationInfo;
    private String postId;
    private String channelType;
    private String deduplicationYn;
    private String msgId;
    private List<Properties> targetServerList;

    public void write(List<? extends TargetData> rawData) throws Exception {
        log.info("rawData size : {}", (Object)rawData.size());
        ArrayList<? extends TargetData> targetDataList = new ArrayList<TargetData>();
        targetDataList.addAll(rawData);
        int duplicateCount = 0;
        if ("Y".equals(this.deduplicationYn)) {
            SqlParameterSource[] dupInsertParam = SqlParameterSourceUtils.createBatch((Object[])targetDataList.toArray());
            try {
                this.sendListServiceImpl.insertSendTempList(dupInsertParam);
            }
            catch (Exception e) {
                log.error("[JdbcOtpmzTargetWriter][ERROR] : " + e.getMessage());
                int size = targetDataList.size();
                for (int i = size - 1; i >= 0; --i) {
                    SqlParameterSource param = dupInsertParam[i];
                    try {
                        this.sendListServiceImpl.insertSendTempList(param);
                        continue;
                    }
                    catch (Exception ee) {
                        targetDataList.remove(i);
                        ++duplicateCount;
                    }
                }
            }
        }
        log.info("[JdbcTargetRawDataWriter] targetDataList.size : {} duplicateCount : {}", (Object)targetDataList.size(), (Object)duplicateCount);
        if (!targetDataList.isEmpty()) {
            long startTime = System.currentTimeMillis();
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            KeyDivider serverIdPartitioner = new KeyDivider("SERVER_ID", "PARTICIPATION_RATE");
            serverIdPartitioner.divisionId(targetDataList.size(), this.targetServerList);
            HashMap<String, Integer> serverIdTargetCntMap = new HashMap<String, Integer>();
            TargetData obj = null;
            String serverId = null;
            Integer serverIdTargetCnt = null;
            int targetSize = targetDataList.size();
            for (int i = 0; i < targetSize; ++i) {
                serverId = serverIdPartitioner.getId(i);
                if (serverIdTargetCnt == null) {
                    serverIdTargetCnt = 0;
                }
                serverIdTargetCnt = serverIdTargetCnt + 1;
                serverIdTargetCntMap.put(serverId, serverIdTargetCnt);
                obj = (TargetData)targetDataList.get(i);
                params.add(new Object[]{this.channelType, this.postId, obj.getChunkId(), serverId, obj.getMemberId(), obj.getMemberName(), obj.getMemberEmail(), obj.getDomain(), obj.getMemberToken(), obj.getDeviceId(), obj.getMemberPhone(), obj.getTelCode(), obj.getField1(), obj.getField2(), obj.getField3(), obj.getField4(), obj.getField5(), obj.getField6(), obj.getField7(), obj.getField8()});
            }
            int[] rows = this.jdbcTemplate.batchUpdate(this.insertSendList, params);
            log.info("insert size : {}, elapseTime:{} ", (Object)rows.length, (Object)(System.currentTimeMillis() - startTime));
            this.jdbcTemplate.update(this.updateScheduleInfo, new Object[]{params.size(), this.postId});
            this.targetServerService.updateTargetServerInfo(this.postId, serverIdTargetCntMap);
        } else if (duplicateCount > 0) {
            this.jdbcTemplate.update(this.updateDeduplicationInfo, new Object[]{duplicateCount, this.msgId});
        }
    }

    public void beforeStep(StepExecution stepExecution) {
        this.postId = stepExecution.getJobParameters().getString("post.id");
        this.channelType = stepExecution.getJobParameters().getString("chn.type");
        this.deduplicationYn = stepExecution.getJobParameters().getString("deduplication.yn");
        this.targetServerList = this.targetServerService.getTargetServerList(this.postId);
        this.msgId = stepExecution.getJobParameters().getString("msg.id");
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return stepExecution.getExitStatus();
    }

    public void setInsertSendList(String insertSendList) {
        this.insertSendList = insertSendList;
    }

    public void setUpdateScheduleInfo(String updateScheduleInfo) {
        this.updateScheduleInfo = updateScheduleInfo;
    }

    public void setUpdateDeduplicationInfo(String updateDeduplicationInfo) {
        this.updateDeduplicationInfo = updateDeduplicationInfo;
    }
}

