/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.writer;

import com.humuson.tms.batch.domain.FatigueFilterSchedule;
import com.humuson.tms.batch.domain.FatigueInfo;
import com.humuson.tms.constrants.CommonType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;

public class FatigueListWriter
implements ItemWriter<FatigueInfo>,
StepExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(FatigueListWriter.class);
    private static final String UNDER_BAR = "_";
    String sendType;
    String siteId;
    String postId;
    String serverId;
    String channelType;
    private String selectSiteFatigueFilterCntSql;
    private String filteredSendListUpdateSql;
    private String filteredCampSendListUpdateSql;
    private String filteredAutoSendListUpdateSql;
    private String updateSchdlFilterCntSql;
    private String updateCampSchdlFilterCntSql;
    private String updateAutoSchdlFilterCntSql;
    @Autowired
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    JdbcTemplate jdbcTemplate;

    public void write(List<? extends FatigueInfo> rawData) throws Exception {
        if (rawData.isEmpty()) {
            return;
        }
        SqlParameterSource[] params = SqlParameterSourceUtils.createBatch((Object[])rawData.toArray());
        int filterCnt = rawData.size();
        this.filteredSendListUpdateSql = CommonType.MASS.getCode().equals(this.sendType) ? this.filteredCampSendListUpdateSql : this.filteredAutoSendListUpdateSql;
        try {
            this.namedParameterJdbcTemplate.batchUpdate(this.filteredSendListUpdateSql, params);
        }
        catch (DataAccessException e) {
            log.error("updateFilteredUserErrorCode batch update error siteId : {}, postId : {}, channelType : {}", new Object[]{this.siteId, this.postId, this.channelType});
            log.error("updateFilteredUserErrorCode batch update error ", (Throwable)e);
            int size = rawData.size();
            for (int i = size - 1; i >= 0; --i) {
                SqlParameterSource param = params[i];
                try {
                    this.namedParameterJdbcTemplate.update(this.filteredSendListUpdateSql, param);
                    continue;
                }
                catch (Exception e2) {
                    --filterCnt;
                    FatigueInfo info = rawData.get(i);
                    log.error("updateFilteredUserErrorCode duplicate skip siteId : {}, postId : {}, channelType : {}, memberId : {}", new Object[]{this.siteId, this.channelType, info.getMemberId(), info.getWorkday()});
                }
            }
        }
        this.updateSchdlFilterCnt(filterCnt);
    }

    public void updateSchdlFilterCnt(int filterCnt) {
        FatigueFilterSchedule info = new FatigueFilterSchedule();
        info.setServerId(this.serverId);
        info.setFilterCnt(filterCnt);
        if (CommonType.MASS.getCode().equals(this.sendType)) {
            info.setPostId(this.postId);
            this.updateSchdlFilterCntSql = this.updateCampSchdlFilterCntSql;
        } else {
            String[] workdayAndSeqno = this.postId.split(UNDER_BAR);
            if (workdayAndSeqno.length < 2) {
                return;
            }
            String workday = workdayAndSeqno[0];
            int seqno = Integer.parseInt(workdayAndSeqno[1]);
            info.setWorkday(workday);
            info.setSeqno(seqno);
            this.updateSchdlFilterCntSql = this.updateAutoSchdlFilterCntSql;
        }
        this.namedParameterJdbcTemplate.update(this.updateSchdlFilterCntSql, (SqlParameterSource)new BeanPropertySqlParameterSource((Object)info));
    }

    public void beforeStep(StepExecution stepExecution) {
        this.sendType = stepExecution.getJobParameters().getString("send.type");
        this.siteId = stepExecution.getJobParameters().getString("site.id");
        this.postId = stepExecution.getJobParameters().getString("post.id");
        this.serverId = stepExecution.getJobParameters().getString("server.id");
        this.channelType = stepExecution.getJobParameters().getString("chn.type");
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return stepExecution.getExitStatus();
    }

    public void setSelectSiteFatigueFilterCntSql(String selectSiteFatigueFilterCntSql) {
        this.selectSiteFatigueFilterCntSql = selectSiteFatigueFilterCntSql;
    }

    public void setFilteredCampSendListUpdateSql(String filteredCampSendListUpdateSql) {
        this.filteredCampSendListUpdateSql = filteredCampSendListUpdateSql;
    }

    public void setFilteredAutoSendListUpdateSql(String filteredAutoSendListUpdateSql) {
        this.filteredAutoSendListUpdateSql = filteredAutoSendListUpdateSql;
    }

    public void setUpdateCampSchdlFilterCntSql(String updateCampSchdlFilterCntSql) {
        this.updateCampSchdlFilterCntSql = updateCampSchdlFilterCntSql;
    }

    public void setUpdateAutoSchdlFilterCntSql(String updateAutoSchdlFilterCntSql) {
        this.updateAutoSchdlFilterCntSql = updateAutoSchdlFilterCntSql;
    }
}

