/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.writer;

import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.DirectQueue;
import com.humuson.tms.batch.domain.DirectQueueResult;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.domain.PushQueue;
import com.humuson.tms.batch.domain.PushResult;
import com.humuson.tms.batch.service.DirectPushResultService;
import com.humuson.tms.batch.service.MqProducer;
import com.humuson.tms.batch.service.PushInfoService;
import com.humuson.tms.batch.service.PushSendService;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.mq.model.MgsPush;
import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class DirectPushSendWriter
implements ItemWriter<DirectQueue>,
StepExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(DirectPushSendWriter.class);
    @Autowired
    protected PushSendService<List<PushQueue>, List<PushResult>> mgsPushSendServiceImpl;
    protected String appGrpKey;
    protected App appInfo;
    @Autowired
    @Qualifier(value="mqAutoReqProducer")
    private MqProducer mqAutoReqProducer;
    @Autowired
    @Qualifier(value="mqFastAutoReqProducer")
    private MqProducer mqFastAutoReqProducer;
    @Autowired
    protected DirectPushResultService directPushResultService;
    @Autowired
    protected PushInfoService<App, PushMessage> pushInfoService;

    public void beforeStep(StepExecution stepExecution) {
        this.appInfo = this.pushInfoService.getAppInfo(this.appGrpKey);
    }

    public void write(List<? extends DirectQueue> rawData) throws Exception {
        MgsPush.Request.Builder gcmRequestBuilder = MgsPush.Request.newBuilder().setAppKey(this.appInfo.getAppKey("A")).setAckMode(MgsPush.Request.AckMode.ACK).setPushChnType(MgsPush.PushChnType.GCM).setSendType(MgsPush.Request.SendType.ONE2ONE).setSeverId("01");
        MgsPush.Request.Builder gcmFastRequestBuilder = MgsPush.Request.newBuilder().setAppKey(this.appInfo.getAppKey("A")).setAckMode(MgsPush.Request.AckMode.ACK).setPushChnType(MgsPush.PushChnType.GCM).setSendType(MgsPush.Request.SendType.ONE2ONE).setSeverId("01");
        MgsPush.Request.Builder apnsRequestBuilder = MgsPush.Request.newBuilder().setAppKey(this.appInfo.getAppKey("I")).setAckMode(MgsPush.Request.AckMode.ACK).setPushChnType(MgsPush.PushChnType.APNS).setSendType(MgsPush.Request.SendType.ONE2ONE).setSeverId("01");
        MgsPush.Request.Builder apnsFastRequestBuilder = MgsPush.Request.newBuilder().setAppKey(this.appInfo.getAppKey("I")).setAckMode(MgsPush.Request.AckMode.ACK).setPushChnType(MgsPush.PushChnType.APNS).setSendType(MgsPush.Request.SendType.ONE2ONE).setSeverId("01");
        MgsPush.PushPayload.Builder payloadBuilder = MgsPush.PushPayload.newBuilder();
        try {
            List<DirectQueue> rawData2 = rawData;
            this.directPushResultService.batchUpdateDirectQueue(rawData2);
        }
        catch (Exception e) {
            log.warn("[DIRECT] TMS_QUEUE batch update fail {}", (Object)e.getMessage());
            for (DirectQueue directQueue : rawData) {
                try {
                    this.directPushResultService.updateDirectQueue(directQueue);
                }
                catch (Exception e2) {
                    log.error("[DIRECT] TMS_QUEUE update fail [{}] msg:{}", (Object)directQueue.toString(), (Object)e.getMessage());
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<DirectQueueResult> resultList = new ArrayList<DirectQueueResult>();
        for (DirectQueue item : rawData) {
            if ("N".equals(item.getNotiFlag())) {
                resultList.add(new DirectQueueResult(item, "4400"));
                continue;
            }
            payloadBuilder.clear();
            sb.setLength(0);
            sb.append("PUSH_ID_VALUE").append("&&").append(item.getDeviceId()).append("&&").append(item.getReqUid()).append("&&").append(item.getCustId()).toString();
            payloadBuilder.setId(sb.toString()).setToken(item.getPushToken());
            if ("A".equals(item.getAppOs())) {
                payloadBuilder.setGcmMessage(this.makeGcmMqMessage(item));
                if (item.getPriority() > 0) {
                    gcmFastRequestBuilder.addPayload(payloadBuilder.build());
                } else {
                    gcmRequestBuilder.addPayload(payloadBuilder.build());
                }
            } else if ("I".equals(item.getAppOs())) {
                payloadBuilder.setApnsMessage(this.makeApnsMqMessage(item));
                if (item.getPriority() > 0) {
                    apnsFastRequestBuilder.addPayload(payloadBuilder.build());
                } else {
                    apnsRequestBuilder.addPayload(payloadBuilder.build());
                }
            }
            resultList.add(new DirectQueueResult(item));
        }
        if (!apnsFastRequestBuilder.getPayloadList().isEmpty()) {
            this.mqFastAutoReqProducer.send(apnsFastRequestBuilder.build());
        }
        if (!gcmFastRequestBuilder.getPayloadList().isEmpty()) {
            this.mqFastAutoReqProducer.send(gcmFastRequestBuilder.build());
        }
        if (!apnsRequestBuilder.getPayloadList().isEmpty()) {
            this.mqAutoReqProducer.send(apnsRequestBuilder.build());
        }
        if (!gcmRequestBuilder.getPayloadList().isEmpty()) {
            this.mqAutoReqProducer.send(gcmRequestBuilder.build());
        }
        try {
            log.info("[DIRECT] result size :{}", (Object)resultList.size());
            this.directPushResultService.batchInsertDirectQueueResult(resultList);
        }
        catch (Exception exception) {
            log.error("[DIRECT] TMS_QUEUE_RESULT batch update fail {}", (Throwable)exception);
            for (DirectQueueResult item : resultList) {
                try {
                    this.directPushResultService.insertDirectQueueResult(item);
                }
                catch (Exception e2) {
                    log.error("[DIRECT] TMS_QUEUE_RESULT update fail [{}] msg:{}", (Object)item.toString(), (Object)exception.getMessage());
                }
            }
        }
        log.info("ActiveMQ SEND [END] APNS:{},GCM:{},APNS_fast:{},GCM_fast:{}", new Object[]{apnsRequestBuilder.getPayloadList().size(), gcmRequestBuilder.getPayloadList().size(), apnsFastRequestBuilder.getPayloadList().size(), gcmFastRequestBuilder.getPayloadList().size()});
    }

    private MgsPush.GcmMessage makeGcmMqMessage(DirectQueue item) {
        MgsPush.GcmMessage.Builder gcmMsgBuilder = MgsPush.GcmMessage.newBuilder();
        gcmMsgBuilder.setTimeToLive(1800).setDelayWhileIdle(false).setPushRichContent("").setPushNotiTitle(item.getSubject()).setPushNotiMsg(item.getContent()).setPushNotiImg(item.getImgUrl()).setMsgType("T").setMsgId("DIRECT_SEQ" + item.getSeq());
        JSONObject json = new JSONObject();
        if (!StringUtils.isNull((String)item.getPushValue())) {
            json.put((Object)"l", (Object)StringUtils.validString((String)item.getPushValue()));
        }
        gcmMsgBuilder.setPushData(json.toString());
        return gcmMsgBuilder.build();
    }

    private MgsPush.ApnsMessage makeApnsMqMessage(DirectQueue item) {
        MgsPush.ApnsMessage.Builder apnsMsgBuilder = MgsPush.ApnsMessage.newBuilder();
        apnsMsgBuilder.setMessage(item.getSubject() + "\n" + item.getContent()).setSound(StringUtils.validString((String)"")).setMsgType("T").setMsgId("DIRECT_SEQ" + item.getSeq());
        if (!StringUtils.isNull((String)item.getPushValue())) {
            apnsMsgBuilder.setPushKey("l").setPushValue(StringUtils.validString((String)item.getPushValue()));
        }
        return apnsMsgBuilder.build();
    }

    public ExitStatus afterStep(StepExecution arg0) {
        return null;
    }

    public void setAppGrpKey(String appGrpKey) {
        this.appGrpKey = appGrpKey;
    }
}

