/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.writer;

import com.humuson.amc.client.model.response.Audience;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;

public class AmcApiTargetingWriter
implements ItemWriter<Audience>,
StepExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(AmcApiTargetingWriter.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private String insertAmcTargetUserList;
    private StepExecution stepExecution;

    public void write(List<? extends Audience> rawData) throws Exception {
        SqlParameterSource[] params = SqlParameterSourceUtils.createBatch((Object[])rawData.toArray());
        long startTime = System.currentTimeMillis();
        try {
            this.namedParameterJdbcTemplate.batchUpdate(this.insertAmcTargetUserList, params);
        }
        catch (DuplicateKeyException e) {
            log.error("AmcApiTargetingWriter batch insert Fail  =>  one2one insert error");
            for (SqlParameterSource param : params) {
                try {
                    this.namedParameterJdbcTemplate.update(this.insertAmcTargetUserList, param);
                }
                catch (DuplicateKeyException duplicateKeyException) {
                    // empty catch block
                }
            }
        }
        log.info("AmcApiTargetingWriter insert success - elapseTime : {}", (Object)(System.currentTimeMillis() - startTime));
    }

    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return stepExecution.getExitStatus();
    }

    public static void main(String[] args) {
        String a = "lBME72nnpBRKBnzm/oph9+5eo8opEDDZIat9OtjK4l4=";
        System.out.println(a.length());
    }

    public void setInsertAmcTargetUserList(String insertAmcTargetUserList) {
        this.insertAmcTargetUserList = insertAmcTargetUserList;
    }
}

