/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.writer;

import com.humuson.tms.batch.domain.BaseResult;
import com.humuson.tms.batch.domain.ChannelSendType;
import com.humuson.tms.batch.service.UpdateResultService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public abstract class AbstractResultWriter<T extends BaseResult>
implements ItemWriter<T>,
StepExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractResultWriter.class);
    public static final String SEND = "S";
    public static final String READ = "R";
    public static final String CLICK = "C";
    public static final String DELIVER = "D";
    @Autowired
    protected JdbcTemplate jdbcTemplate;
    @Autowired
    protected NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    @Autowired
    protected UpdateResultService updateResultServiceImpl;
    protected String updateCheckFlag;
    protected String updateAutoSendList;
    protected String updateAutoSendListByRowId;
    protected String updateCampSendList;
    protected String updateCampSendListByRowId;
    protected String updateAutoScheduleStat;
    protected String updateCampScheduleStat;
    protected String updateAutoOpenList;
    protected String updateCampOpenList;
    protected String updateAutoClickList;
    protected String updateCampClickList;
    protected String updateAutoOpenStat;
    protected String updateCampOpenStat;
    protected String updateAutoClickStat;
    protected String updateCampClickStat;
    protected String updateCampClickLinkStat;
    protected String updateAutoClickLinkStat;
    protected String updateAutoSendListDeliver;
    protected String updateAutoSendListDeliverByRowId;
    protected String updateCampSendListDeliver;
    protected String updateCampSendListDeliverByRowId;

    public void write(List<? extends T> rawData) throws Exception {
        if (rawData.isEmpty()) {
            return;
        }
        this.updateCheckFlag(rawData);
        HashMap<String, ArrayList<BaseResult>> devidePostIdMap = new HashMap<String, ArrayList<BaseResult>>();
        String key = null;
        for (BaseResult baseResult : rawData) {
            ArrayList<BaseResult> postIdList;
            if (baseResult.getType().startsWith(CLICK)) {
                key = baseResult.getType() + "_" + baseResult.getPostId() + "_" + baseResult.getRtnType();
            } else if (baseResult.getType().startsWith("A")) {
                key = baseResult.getType() + "_" + baseResult.getWorkday() + "_" + baseResult.getSeqNo() + "_" + baseResult.getRtnType();
            }
            if (key == null) {
                log.error(baseResult.getType());
            }
            if ((postIdList = (ArrayList<BaseResult>)devidePostIdMap.get(key)) == null) {
                postIdList = new ArrayList<BaseResult>();
            }
            postIdList.add(baseResult);
            devidePostIdMap.put(key, postIdList);
        }
        Set keySet = devidePostIdMap.keySet();
        String type = null;
        String postId = null;
        String rtnType = null;
        String[] keys = null;
        ChannelSendType sendType = null;
        for (String resultKey : keySet) {
            keys = resultKey.split("_");
            type = keys[0];
            if (type.startsWith(CLICK)) {
                postId = keys[1];
                rtnType = keys[2];
                sendType = ChannelSendType.CAMP;
            } else if (type.startsWith("A")) {
                postId = keys[1] + "_" + keys[2];
                rtnType = keys[3];
                sendType = ChannelSendType.AUTO;
            }
            this.execute(sendType, postId, rtnType, (List)devidePostIdMap.get(resultKey));
        }
    }

    protected abstract void updateCheckFlag(List<? extends T> var1);

    public abstract void execute(ChannelSendType var1, String var2, String var3, List<T> var4);

    public void beforeStep(StepExecution stepExecution) {
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return null;
    }

    public void setUpdateCheckFlag(String updateCheckFlag) {
        this.updateCheckFlag = updateCheckFlag;
    }

    public void setUpdateAutoSendList(String updateAutoSendList) {
        this.updateAutoSendList = updateAutoSendList;
    }

    public void setUpdateAutoSendListByRowId(String updateAutoSendListByRowId) {
        this.updateAutoSendListByRowId = updateAutoSendListByRowId;
    }

    public void setUpdateCampSendList(String updateCampSendList) {
        this.updateCampSendList = updateCampSendList;
    }

    public void setUpdateCampSendListByRowId(String updateCampSendListByRowId) {
        this.updateCampSendListByRowId = updateCampSendListByRowId;
    }

    public void setUpdateAutoScheduleStat(String updateAutoScheduleStat) {
        this.updateAutoScheduleStat = updateAutoScheduleStat;
    }

    public void setUpdateCampScheduleStat(String updateCampScheduleStat) {
        this.updateCampScheduleStat = updateCampScheduleStat;
    }

    public void setUpdateAutoOpenList(String updateAutoOpenList) {
        this.updateAutoOpenList = updateAutoOpenList;
    }

    public void setUpdateCampOpenList(String updateCampOpenList) {
        this.updateCampOpenList = updateCampOpenList;
    }

    public void setUpdateAutoClickList(String updateAutoClickList) {
        this.updateAutoClickList = updateAutoClickList;
    }

    public void setUpdateCampClickList(String updateCampClickList) {
        this.updateCampClickList = updateCampClickList;
    }

    public void setUpdateAutoOpenStat(String updateAutoOpenStat) {
        this.updateAutoOpenStat = updateAutoOpenStat;
    }

    public void setUpdateCampOpenStat(String updateCampOpenStat) {
        this.updateCampOpenStat = updateCampOpenStat;
    }

    public void setUpdateAutoClickStat(String updateAutoClickStat) {
        this.updateAutoClickStat = updateAutoClickStat;
    }

    public void setUpdateCampClickStat(String updateCampClickStat) {
        this.updateCampClickStat = updateCampClickStat;
    }

    public void setUpdateCampClickLinkStat(String updateCampClickLinkStat) {
        this.updateCampClickLinkStat = updateCampClickLinkStat;
    }

    public void setUpdateAutoClickLinkStat(String updateAutoClickLinkStat) {
        this.updateAutoClickLinkStat = updateAutoClickLinkStat;
    }

    public void setUpdateAutoSendListDeliver(String updateAutoSendListDeliver) {
        this.updateAutoSendListDeliver = updateAutoSendListDeliver;
    }

    public void setUpdateAutoSendListDeliverByRowId(String updateAutoSendListDeliverByRowId) {
        this.updateAutoSendListDeliverByRowId = updateAutoSendListDeliverByRowId;
    }

    public void setUpdateCampSendListDeliver(String updateCampSendListDeliver) {
        this.updateCampSendListDeliver = updateCampSendListDeliver;
    }

    public void setUpdateCampSendListDeliverByRowId(String updateCampSendListDeliverByRowId) {
        this.updateCampSendListDeliverByRowId = updateCampSendListDeliverByRowId;
    }
}

