/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.step.filter;

import com.humuson.tms.batch.step.filter.Validator;
import com.humuson.tms.common.model.target.TargetData;
import com.humuson.tms.common.security.HumusonDecryptor;
import com.humuson.tms.common.security.HumusonEncryptor;
import com.humuson.tms.common.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class ValidationSmsChannel
implements Validator<TargetData> {
    private static final Logger log = LoggerFactory.getLogger(ValidationSmsChannel.class);
    private String sourceTargetEncryptYn;
    private String dbEncryptFlag;
    @Value(value="#{config['tms.db.enc.key']}")
    private String encKey;

    @Override
    public boolean checkValidation(TargetData t, boolean isStrict) {
        String phone = t.getMemberPhone();
        if ("Y".equals(this.sourceTargetEncryptYn)) {
            try {
                phone = HumusonDecryptor.decrypt((String)phone, (String)this.encKey, (boolean)false);
            }
            catch (Exception e) {
                phone = null;
                log.error("decrypt error", (Throwable)e);
            }
        }
        if (isStrict && StringUtils.isSmsError((String)phone)) {
            return false;
        }
        t.setTelCode(StringUtils.getTeleCom((String)phone));
        if ("Y".equals(this.dbEncryptFlag)) {
            t.setMemberPhone(HumusonEncryptor.encrypt((String)phone, (String)this.encKey, (boolean)false));
        } else {
            t.setMemberPhone(phone);
        }
        return true;
    }

    public void setSourceTargetEncryptYn(String sourceTargetEncryptYn) {
        this.sourceTargetEncryptYn = sourceTargetEncryptYn;
    }

    public void setDbEncryptFlag(String dbEncryptFlag) {
        this.dbEncryptFlag = dbEncryptFlag;
    }
}

