/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.step.filter;

import com.humuson.tms.batch.step.filter.Validator;
import com.humuson.tms.common.model.target.TargetData;
import com.humuson.tms.common.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class ValidationPushChannel
implements Validator<TargetData> {
    private static final Logger log = LoggerFactory.getLogger(ValidationPushChannel.class);
    private String sourceTargetEncryptYn;
    private String dbEncryptFlag;
    @Value(value="#{config['tms.db.enc.key']}")
    private String encKey;

    @Override
    public boolean checkValidation(TargetData t, boolean isStrict) {
        if (log.isDebugEnabled()) {
            log.debug("TargetData:{}, isStrict:{}", (Object)t.toString(), (Object)isStrict);
        }
        return !isStrict || !StringUtils.isNull((String)t.getDeviceId()) && !StringUtils.isNull((String)t.getMemberToken());
    }

    public void setSourceTargetEncryptYn(String sourceTargetEncryptYn) {
        this.sourceTargetEncryptYn = sourceTargetEncryptYn;
    }

    public void setDbEncryptFlag(String dbEncryptFlag) {
        this.dbEncryptFlag = dbEncryptFlag;
    }
}

