/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.step.filter;

import com.humuson.tms.batch.step.filter.Validator;
import com.humuson.tms.common.model.target.TargetData;
import com.humuson.tms.common.security.HumusonDecryptor;
import com.humuson.tms.common.security.HumusonEncryptor;
import com.humuson.tms.common.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class ValidationEmailChannel
implements Validator<TargetData> {
    private static final Logger log = LoggerFactory.getLogger(ValidationEmailChannel.class);
    private String sourceTargetEncryptYn;
    private String dbEncryptFlag;
    @Value(value="#{config['tms.db.enc.key']}")
    private String encKey;

    @Override
    public boolean checkValidation(TargetData t, boolean isStrict) {
        String email = t.getMemberEmail();
        if ("Y".equals(this.sourceTargetEncryptYn)) {
            try {
                email = HumusonDecryptor.decrypt((String)email, (String)this.encKey, (boolean)false);
            }
            catch (Exception e) {
                email = null;
                log.error("decrypt error", (Throwable)e);
            }
        }
        if (isStrict && StringUtils.isEmailError((String)email)) {
            return false;
        }
        t.setDomain(StringUtils.getDomain((String)email));
        if ("Y".equals(this.dbEncryptFlag)) {
            t.setMemberEmail(HumusonEncryptor.encrypt((String)email, (String)this.encKey, (boolean)false));
        } else {
            t.setMemberEmail(email);
        }
        return true;
    }

    public void setSourceTargetEncryptYn(String sourceTargetEncryptYn) {
        this.sourceTargetEncryptYn = sourceTargetEncryptYn;
    }

    public void setDbEncryptFlag(String dbEncryptFlag) {
        this.dbEncryptFlag = dbEncryptFlag;
    }
}

