/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.humuson.tms.batch.domain.BaseResult;
import com.humuson.tms.batch.domain.ChannelSendType;
import com.humuson.tms.batch.service.UpdateResultService;
import com.humuson.tms.constrants.ChannelType;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class UpdateResultServiceImpl
implements UpdateResultService {
    private static final Logger log = LoggerFactory.getLogger(UpdateResultServiceImpl.class);
    @Autowired
    protected NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    @Override
    public int updateCheckFlag(String updateSql, BaseResult result) {
        SqlParameterSource[] params = SqlParameterSourceUtils.createBatch((Object[])new Object[]{result});
        return this.namedParameterJdbcTemplate.update(updateSql, params[0]);
    }

    @Override
    public int[] updateCheckFlag(String updateSql, BaseResult[] results) throws Exception {
        SqlParameterSource[] params = SqlParameterSourceUtils.createBatch((Object[])results);
        return this.namedParameterJdbcTemplate.batchUpdate(updateSql, params);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Throwable.class})
    public int[] updateList(ChannelType chnType, ChannelSendType chnSendType, String rtnType, String sql, SqlParameterSource[] param) throws Exception {
        int[] result = null;
        result = this.namedParameterJdbcTemplate.batchUpdate(sql, param);
        if (log.isDebugEnabled()) {
            log.debug("updateList Size: {}", (Object)result.length);
        }
        return result;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public int updateStat(String sql, Map<String, Object> statMap) throws Exception {
        return this.namedParameterJdbcTemplate.update(sql, statMap);
    }

    @Override
    public int alreadExistClickInfo(String selectExistClickInfo, BeanPropertySqlParameterSource param) {
        return (Integer)this.namedParameterJdbcTemplate.queryForObject(selectExistClickInfo, (SqlParameterSource)param, Integer.class);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public int[] updateResponseStat(String updateSql, SqlParameterSource[] params) throws Exception {
        return this.namedParameterJdbcTemplate.batchUpdate(updateSql, params);
    }
}

