/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.service.impl;

import com.humuson.tms.batch.service.TargetServerService;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class TargetServerServiceImpl
implements TargetServerService {
    private static final Logger log = LoggerFactory.getLogger(TargetServerServiceImpl.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private String selectTargetServerInfo;
    private String updateTargetServerInfo;
    private String initTargetServerInfo;

    @Override
    public List<Properties> getTargetServerList(String postId) {
        List targetServerList = this.jdbcTemplate.query(this.selectTargetServerInfo, (RowMapper)new RowMapper<Properties>(){

            public Properties mapRow(ResultSet rs, int rowNum) throws SQLException {
                Properties properties = new Properties();
                properties.put("SERVER_ID", rs.getString("SERVER_ID"));
                properties.put("PARTICIPATION_RATE", rs.getString("PARTICIPATION_RATE"));
                log.info(properties.toString());
                return properties;
            }
        }, new Object[]{postId});
        log.info("targetServerList :{}", (Object)targetServerList.toString());
        return targetServerList;
    }

    @Override
    public int updateTargetServerInfo(String postId, String serverId, int targetCnt) {
        int uptCnt = this.jdbcTemplate.update(this.updateTargetServerInfo, new Object[]{targetCnt, postId, serverId});
        log.info("update TMS_TARGET_SERVER [postId:{}, serverId:{}, count:{}]", new Object[]{postId, serverId, targetCnt});
        return uptCnt;
    }

    @Override
    public int updateTargetServerInfo(String postId, Map<String, Integer> serverIdTargetCntMap) {
        int uptCnt = 0;
        Set<String> serverIdSet = serverIdTargetCntMap.keySet();
        for (String targetServerId : serverIdSet) {
            int targetCnt = serverIdTargetCntMap.get(targetServerId);
            uptCnt += this.updateTargetServerInfo(postId, targetServerId, targetCnt);
        }
        return uptCnt;
    }

    @Override
    public int initTargetServerInfo(String postId) {
        int cnt = this.jdbcTemplate.update(this.initTargetServerInfo, new Object[]{postId});
        return cnt;
    }

    public void setSelectTargetServerInfo(String selectTargetServerInfo) {
        this.selectTargetServerInfo = selectTargetServerInfo;
    }

    public void setUpdateTargetServerInfo(String updateTargetServerInfo) {
        this.updateTargetServerInfo = updateTargetServerInfo;
    }

    public void setInitTargetServerInfo(String initTargetServerInfo) {
        this.initTargetServerInfo = initTargetServerInfo;
    }
}

